processings = [
    "*",
    "sberbank_direct",
    "sberbank_rbs_h2h_ru",
    "yamoney_h2h",
    "payture_applepay",
    "yandex_account_topup",
    "sberbank_rbs_apple_pay_ru_v2",
    "payture_googlepay",
    "yandex_account_withdraw",
    "sberbank_h2h_kz",
    "ecommpay_gate_h2h",
    "payture",
    "rbs_h2h_ru",
    "cardpay",
    "payture_paybox",
    "rbs_vbrr",
    "rbs_vbrr_apple_pay",
    "tinkoff_h2h_rbs_ru",
    "tinkoff_sbp_qr",
    "payture_upay",
    "rbs_vbrr_google_pay",
    "cardpay_apple_pay",
    "tinkoff_credit",
    "rbk_money_h2h",
    "rbs_alfa_h2h_by",
    "rbs_h2h_kz",
    "rbs_investments_c2a",
    "sberbank_apple_pay_ru",
    "yamoney",
    "yamoney_cardapi_v3",
    "stripe",
    "open_aft_h2h",
    "rbs_vbrr_sbp",
    "yabank_wallet",
    "composite",
]
import json


metrics = [
# aliasByNode(one_min.greedaggrprod_yandex_ru.simplebrother_balance_bo.payment_resp_codes_pg_bs.20m.s143.$processings.*.CNT, -2)
    "{project=\"trust\", cluster=\"greed-prod\", service=\"trust_brother\", aggregate=\"20m\", name=\"CNT\", status_code=\"success\", service_id=\"{{service_id}}\", currency=\"{{currency}}\", processing_cc=\"{{processing_cc}}\" }",
# aliasByNode(one_min.greedaggrprod_yandex_ru.simplebrother_balance_bo.payment_resp_codes_pg_bs.20m.s143.[[processings]].*.CNT_RATIO, -2)
    "{project=\"trust\", cluster=\"greed-prod\", service=\"trust_brother\", aggregate=\"20m\", name=\"CNT_RATIO\", service_id=\"{{service_id}}\", currency=\"{{currency}}\", processing_cc=\"{{processing_cc}}\", }",
# aliasByNode(averageSeries(exclude(exclude(one_min.greedaggrprod_yandex_ru.simplebrother_balance_bo.terminal_authorization_time.{tpay,bs}.*.rbs_tokenize.*.no3ds.percentile_95,
# !!service_id
 #"{project=\"trust\", cluster=\"greed-prod\", service=\"trust_brother\", metric_group=\"terminal_authorization_time\", name=\"percentile_95\", flag_3ds=\"no3ds\", host=\"*\", processing_cc=\"payture\", }"
# terminal statistic
    # !!service_id
  #"sum({project=\"trust\", cluster=\"greed-prod\", service=\"trust_brother\", metric_group=\"terminal_authorization_time\", name=\"percentile_95\", flag_3ds=\"no3ds\", host=\"*\", processing_cc=\"payture\", }) by obj_id"
]

graphs = [
    "payment_resp_codes_pg",
    "payment_resp_codes_ratio",
    "terminal_authorization_time",
    "service_terminal_payments_p95_time",
]
graphs_names = [
    "Response Codes count for %s",
    "Response Codes ratio for %s",
    "Processing authorization time for %s",
    "Terminals p95 authorization time for %s",
]

if __name__ == '__main__':
    dashbord_json = open("dashboards/payment_resp_codes.json", "r")
    try:
        data = json.loads(dashbord_json.read())
        rows = list()
        for processing_idx, processing in enumerate(processings):
            row = dict()
            panels = list()
            for graph_idx, graph in enumerate(graphs):
                panel = dict()
                panel["type"] = "IFRAME"
                panel["title"] = graphs_names[graph_idx] % (processing)
                if processing_idx == 0 and graph_idx == 1:#all
                    panel["url"] = "/?project=trust&cluster=greed-prod&graph=payment_resp_codes_pg_pie&service_id={{service_id}}&currency={{currency}}&processing_cc=%s" % (processing)
                elif graph_idx == 3:#Terminals p95
                    panel["url"] = "/?project=trust&cluster=greed-prod&graph=%s&service_id={{service_id}}&&currency={{currency}}&flag_3ds=*&processing_cc=%s" % (graph, processing)
                else:
                    panel["url"] = "/?project=trust&cluster=greed-prod&graph=%s&service_id={{service_id}}&currency={{currency}}&processing_cc=%s" % (graph, processing)
                panel["rowspan"] = 0
                panel["colspan"] = 6
                panels.append(panel)
            row["panels"] = panels
            rows.append(row)
        data['rows'] = rows
        print(json.dumps(data))
    finally:
        dashbord_json.close()

# drop_nan(sum({project=="trust", cluster=="greed-prod", service=="trust_brother", metric_group=="payment_resp_codes", aggregate=="20m", name=="CNT", status_code=="success", host=*}) by processing_cc)
