import os
import yaml
import json
import requests
import logging
import tempfile
import zipfile
import shutil
import commands

try:
    import http.client as http_client
except ImportError:
    import httplib as http_client
    http_client.HTTPConnection.debuglevel = 1

    logging.basicConfig()
    logging.getLogger().setLevel(logging.DEBUG)
    requests_log = logging.getLogger("requests.packages.urllib3")
    requests_log.setLevel(logging.DEBUG)
    requests_log.propagate = True

spec = None

with open("swagger-spec.yml") as swagger_spec:
    spec = yaml.load(swagger_spec)

data = {
    "spec": spec,
    "options": {
        "packageName": "yasm_alert",
        "packageVersion": "1.0.5",
    }
}

print data

gen_archive = requests.post(
    "https://generator.swagger.io/api/gen/clients/python",
    json=data,
    headers={
        "Content-Type": "application/json",
    },
    verify=False,
)

link = gen_archive.json()['link']


with tempfile.TemporaryFile() as tmp_file:
    get_archive = requests.get(
        link,
        stream=True,
        verify=False,
    )

    for chunk in get_archive.iter_content(chunk_size=512):
        if chunk:
            tmp_file.write(chunk)

    if os.path.exists("python-client"):
        shutil.rmtree('python-client')

    with zipfile.ZipFile(tmp_file, 'r') as zip_file:
        zip_file.extractall(path='.')

print(commands.getstatusoutput("rm -rf ../../../pylibrary/yasm_alert"))
print(commands.getstatusoutput("mv python-client ../../../pylibrary/yasm_alert"))
