#!/bin/bash

BRANCH=${1:-unstable}
ENV=${2:-development}
REPO=${3:-hadoop}
VERSION=${4:-\*}
echo "Building timeline images from Repo:${REPO}/${BRANCH} to ${ENV} environment"

TAG="dev"
if [ ${BRANCH} == "stable" ]; then
   TAG="stable"
elif [ ${BRANCH} == "testing" ]; then
   TAG="test"
else
   TAG="dev"
fi

docker build  -t registry.yandex.net/paysys/timeline/base:base base/

docker build  -t registry.yandex.net/paysys/timeline/timeline:${TAG} --build-arg BRANCH=$BRANCH\
 --build-arg REPO=$REPO --build-arg ENVIRONMENT=$ENV --build-arg API_VERSION=$VERSION\
 --build-arg UI_VERSION=$VERSION --build-arg TMS_VERSION=$VERSION timeline/
