from privacy_office.lib.soft_request.main import soft_request, st_host
from privacy_office.lib.nirvana_combine.main import combine_this

import json
import time


def get_employees_logins(ticket_employees):
    return list(employee['id'] for employee in ticket_employees)

summary_template = 'Заменить в Нирвана-секрете скомпрометированный токен: {secret_id}'

description_template = '''
Привет!

Я вижу, что ты являешься владельцем Nirvana-секрета ((https://nirvana.yandex-team.ru/secret/{secret_id} {secret_name})). \
К сожалению, этот Nirvana-секрет использовался в кубиках типа "echo secret" — то есть в кубиках, выдающих секрет \
(токен, пароли, ключи доступа) на выход кубика. Поэтому, токен, лежащий в твоём Nirvana-секрете, скомпрометирован.

Моя задача — добиться, чтобы все графы перестали использовать такие кубики, чтобы существующие утечки прекратились, \
и безболезненно устранить последствия всех утечек.

====Необходимо заменить токен в Nirvana-секрете на новый, нескомпрометированный

((https://nirvana.yandex-team.ru/secret/{secret_id} ссылка на Nirvana-секрет))


======Прошу сделать следующее:
0. Дождаться, когда все графы, которые компрометировали содержимое Nirvana-секрета, перестали это делать \
(= когда все задачи-блокеры будут решены). **//=вы находитесь здесь=//**
1. **Ознакомься ((https://wiki.yandex-team.ru/privacy_office/echo-chainsaw/do_not_bring_secrets_to_output/ с памяткой))**, \
объясняющий почему кубики "echo secret" использовать нельзя.
2. Перейди на страницу Nirvana-секрета ((https://nirvana.yandex-team.ru/secret/{secret_id} по ссылке)).
3. Создай новый нескомпрометированный токен с теми же доступами, и прикрепи его к Nirvana-секрету: \
((https://wiki.yandex-team.ru/privacyoffice/echo-chainsaw/change-secret/ **гайд**)).
5. Как токен в Nirvana-секрете будет заменён — **закрой тикет**. Этот тикет блокирует задачи, \
в которых я прошу владельцов скомпрометированных токенов отзывать их, чтобы окончательно устранить утечку.

---
Спасибо!

#|
|| secret_id | %%{secret_id}%%||
|| secret_name | %%{secret_name}%%||
|#
'''


def update_tickets(in1, in2, token_st, debug=None, ignore_subgraphs=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
    else:
        queue_name = "CHSWCHANGE".lower()

    secret_seen = []
    for incident in in1:
        compositeOperationId = incident['compositeOperationId']
        if ignore_subgraphs and incident['is_composite'] and compositeOperationId is None:
            continue

        for secret in incident['secret_info']:

            secret_id = secret['secret_id']
            if secret_id in secret_seen:
                continue

            secret_owners = [secret['secret_author']]

            r = soft_request(
                st_host+'issues/',
                token_st,
                params={
                    "query": f"Queue: {queue_name} Mark: {secret_id}"
                }
            )

            assert len(r) <= 1, f"🧑‍🚒found >1 tickets!🚒 {r[0]['key'], r[1]['key']}"

            if len(r) == 0:
                print("CREATE TICKET")

                summary = summary_template.format(**secret)
                description = description_template.format(**secret)
                ticket = soft_request(
                    st_host+'issues',
                    token_st,
                    json={
                        "queue": queue_name,
                        "type": 'incident',
                        "priority": 'normal',
                        "summary": summary,
                        "description": description,
                        "assignee": None,
                        "access": 'anatoliy-ch',
                        "mark": secret_id,
                        "employees": secret_owners
                    },
                    type='post'
                )
            else:
                print("SAVE TICKET")
                ticket = r[0]

            ticket_key = ticket['key']

            if set(get_employees_logins(ticket.get('employees', []))) != set(secret_owners):
                print('Employees are not actual!')
                soft_request(
                    st_host+f'issues/{ticket_key}',
                    token_st,
                    type='patch',
                    json={
                        "employees": {
                            "remove": get_employees_logins(ticket.get('employees', [])),
                            "add": secret_owners
                        }
                    }
                )

            print(ticket_key)
            secret_seen.append(secret_id)


def update_connections(in1, in2, token_st, debug=None, ignore_subgraphs=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
        fix_queue_name = "CH".lower()
        compfix_queue_name = "CH".lower()
    else:
        queue_name = "CHSWCHANGE".lower()
        fix_queue_name = "CHSWFIX".lower()
        compfix_queue_name = "CHSWCOMPFIX".lower()

    relevant_workflow_secret_is_composite_seen = []
    for incident in in1:
        compositeOperationId = incident['compositeOperationId']
        if ignore_subgraphs and incident['is_composite'] and compositeOperationId is None:
            continue

        for secret in incident['secret_info']:
            secret_id = secret['secret_id']
            is_composite = incident['is_composite']

            relevant_workflowId = incident['workflowId']
            if incident['is_legacy_hitman']:
                print('legacy hitman!')
                relevant_workflowId = incident['legacy_hitman_workflow_id']

            relevant_workflow_secret_is_composite = (relevant_workflowId, secret_id, is_composite)

            if relevant_workflow_secret_is_composite in relevant_workflow_secret_is_composite_seen:
                continue

            r = soft_request(
                st_host+'issues/',
                token_st,
                params={
                    "query": f"Queue: {queue_name} Mark: {secret_id}"
                }
            )
            assert len(r) == 1, f"🧑‍🚒found {len(r)}≠1 tickets!🚒 {queue_name}:{secret_id}"

            ticket = r[0]
            ticket_key = ticket['key']

            if is_composite:
                relevant_queue_name = compfix_queue_name
            else:
                relevant_queue_name = fix_queue_name

            r = soft_request(
                st_host+'issues/',
                token_st,
                params={
                    "query": f"Queue: {relevant_queue_name} Mark: {relevant_workflowId}"
                }
            )
            assert len(r) == 1, f"🧑‍🚒found {len(r)}≠1 tickets!🚒 {relevant_queue_name}:{relevant_workflowId}"
            relevant_ticket_key = r[0]['key']
            r = soft_request(
                st_host+f'issues/{ticket_key}/links',
                token_st,
                type="post",
                json={
                    "relationship": "depends on",
                    "issue": relevant_ticket_key
                },
                status_whitelist=[201, 200, 422]  # 422 это когда связь уже есть
            )
            if 'errors' in r:
                print(f"{relevant_workflowId} is already blocking {secret_id}! {relevant_ticket_key} -> {ticket_key}")
            else:
                print(f"new link! {relevant_ticket_key} -> {ticket_key}")

            print(ticket_key)
            relevant_workflow_secret_is_composite_seen.append(relevant_workflow_secret_is_composite)


@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    if param1 == '':
        params = {}
    else:
        params = json.loads(param1)

    # I создать по тикету на каждый Nirvana-секрет
    print("PART 1/2!")
    update_tickets(in1, in2, token1, **params)

    # создать все нужные связи по таблице инцидентов
    print("PART 2/2!")
    time.sleep(45)
    update_connections(in1, in2, token1, **params)

    return {
        "out1": None,
        "out2": None,
        "out3": None
    }
