from privacy_office.lib.soft_request.main import soft_request, st_host
from privacy_office.lib.nirvana_combine.main import combine_this

import json
# из-за высокой скорости запросов, API Трекера думает,
# что тикет с операцией ещё не создан, и создаёт дубликат
# буду сдавить задержку в 45 секунд на каждый новый кейс
import time


def get_composite_operation_owners(in2):
    composite_operation_owners = {}
    for line in in2:
        composite_operation_owners.setdefault(line["id"], [])
        composite_operation_owners[line["id"]].append(line["created_by_id"])
    return composite_operation_owners


def get_composite_operation_names(in2):
    composite_operation_names = {}
    for line in in2:
        composite_operation_names.setdefault(line["id"], [])
        composite_operation_names[line["id"]].append(line["name"])
    return composite_operation_names


def get_employees_logins(ticket_employees):
    return list(employee['id'] for employee in ticket_employees)

summary_template = 'Удалить старые версии композитной операции: {compositeOperationId}'

description_template = '''
Привет, снова!

В прошлом тикете я просил обновить композитную операцию, чтобы не использовать кубики echo secret. Теперь пора закрыть старые версии, чтобы остановить будущие утечки.

((https://nirvana.yandex-team.ru/operation/{compositeOperationId} ссылка на граф композитной операции))


======Прошу сделать следующее:
0. Выпустить новую, безопасную версию композитной операции. \
Дождаться, когда все пользователи композитных операций обновят в своих графах твою операцию до новой версии. **//=вы находитесь здесь=//**
1. Переведи старые версии кубика из статуса **optional deprecated** в статус **mandatory deprecated**: \
((https://wiki.yandex-team.ru/privacy_office/echo-chainsaw/mandatory-deprecate-cube/ **гайд**)).
2. Как только все старые версии будут удалены (mandatory deprecated) — **закрой тикет**.

---
Спасибо!

#|
|| compositeOperationId| %%{compositeOperationId}%%||
|| name| %%{composite_operation_name}%%||
|#
'''


def update_tickets(in1, in2, token_st, debug=None, ignore_subgraphs=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
    else:
        queue_name = "CHSWCOMPDELETE".lower()

    composite_operation_owners = get_composite_operation_owners(in2)
    composite_operation_names = get_composite_operation_names(in2)

    composite_operation_seen = []
    for incident in in1:
        if not incident['is_composite']:
            # print('is not composite!')
            continue

        compositeOperationId = incident['compositeOperationId']
        if ignore_subgraphs and compositeOperationId is None:
            continue

        composite_operation_name = composite_operation_names[compositeOperationId][0]

        if compositeOperationId in composite_operation_seen:
            continue

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {queue_name} Mark: {compositeOperationId}"
            }
        )
        assert len(r) <= 1, f"🧑‍🚒found >1 tickets!🚒 {r[0]['key'], r[1]['key']}"

        if len(r) == 0:
            print("CREATE TICKET")

            summary = summary_template.format(compositeOperationId=compositeOperationId)
            description = description_template.format(compositeOperationId=compositeOperationId, composite_operation_name=composite_operation_name)
            ticket = soft_request(
                st_host+'issues',
                token_st,
                json={
                    "queue": queue_name,
                    "type": 'incident',
                    "priority": 'normal',
                    "summary": summary,
                    "description": description,
                    "assignee": None,
                    "access": 'anatoliy-ch',
                    "mark": compositeOperationId,
                    "employees": composite_operation_owners[compositeOperationId]
                },
                type='post'
            )
        else:
            print("SAVE TICKET")
            ticket = r[0]

        ticket_key = ticket['key']

        if set(get_employees_logins(ticket.get('employees', []))) != set(composite_operation_owners[compositeOperationId]):
            print('Employees are not actual!')
            soft_request(
                st_host+f'issues/{ticket_key}',
                token_st,
                type='patch',
                json={
                    "employees": {
                        "remove": get_employees_logins(ticket.get('employees', [])),
                        "add": composite_operation_owners[compositeOperationId]
                    }
                }
            )

        print(ticket_key)
        composite_operation_seen.append(compositeOperationId)


def update_connections(in1, in2, token_st, debug=None, ignore_subgraphs=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
        compfix_queue_name = "CH".lower()
    else:
        queue_name = "CHSWCOMPDELETE".lower()
        compfix_queue_name = "CHSWCOMPFIX".lower()

    relevant_workflow_composite_operation_seen = []
    for incident in in1:
        if not incident['is_composite']:
            # print('is not composite!')
            continue

        compositeOperationId = incident['compositeOperationId']
        if ignore_subgraphs and compositeOperationId is None:
            continue

        relevant_workflowId = incident['workflowId']
        if incident['is_legacy_hitman']:
            print('legacy hitman!')
            relevant_workflowId = incident['legacy_hitman_workflow_id']

        relevant_workflow_composite_operation = (relevant_workflowId, compositeOperationId)
        if relevant_workflow_composite_operation in relevant_workflow_composite_operation_seen:
            continue

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {queue_name} Mark: {compositeOperationId}"
            }
        )
        assert len(r) == 1, f"🧑‍🚒found {len(r)}≠1 tickets!🚒 {queue_name}:{compositeOperationId}"

        ticket = r[0]
        ticket_key = ticket['key']

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {compfix_queue_name} Mark: {relevant_workflowId}"
            }
        )
        assert len(r) == 1, f"🧑‍🚒found {len(r)}≠1 tickets!🚒 {compfix_queue_name}:{relevant_workflowId}"
        compfix_ticket_key = r[0]['key']
        r = soft_request(
            st_host+f'issues/{ticket_key}/links',
            token_st,
            type="post",
            json={
                "relationship": "depends on",
                "issue": compfix_ticket_key
            },
            status_whitelist=[201, 200, 422]  # 422 это когда связь уже есть
        )
        if 'errors' in r:
            print(f"{relevant_workflowId} is already blocking {compositeOperationId}! {compfix_ticket_key} -> {ticket_key}")
        else:
            print(f"new link! {compfix_ticket_key} -> {ticket_key}")

        print(ticket_key)
        relevant_workflow_composite_operation_seen.append(relevant_workflow_composite_operation)


@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    if param1 == '':
        params = {}
    else:
        params = json.loads(param1)

    # I создать по тикету на каждый композитный кубик
    print("PART 1/2!")
    update_tickets(in1, in2, token1, **params)

    # II создать все нужные связи по таблице инцидентов
    print("PART 2/2!")
    time.sleep(45)
    update_connections(in1, in2, token1, **params)

    return {
        "out1": None,
        "out2": None,
        "out3": None
    }
