from privacy_office.lib.soft_request.main import soft_request, st_host
from privacy_office.lib.nirvana_combine.main import combine_this
# из-за высокой скорости запросов, API Трекера думает,
# что тикет с операцией ещё не создан, и создаёт дубликат
# буду сдавить задержку в 45 секунд на каждый новый кейс
import time

import json


def get_workflow_owners(in2):
    workflow_owners = {}
    for line in in2:
        workflow_owners.setdefault(line["workflowId"], [])
        workflow_owners[line["workflowId"]].append(line["workflowOwner"])
    return workflow_owners


def get_employees_logins(ticket_employees):
    return list(employee['id'] for employee in ticket_employees)

summary_template = 'Подготовить граф к удалению кубиков: {relevant_workflowId}'

description_template = '''

**Важно!** Если ты не являешься релевантным исполнителем, и робот добавил тебя по ошибке — обязательно отпишись об этом в комментариях, и при возможности — подскажи к кому я могу обратиться.

---

Привет!

Я вижу, что ты являешься одним из пользователей Nirvana-графа ((https://nirvana.yandex-team.ru/flow/{relevant_workflowId} {relevant_workflowId})). В этом воркфлоу использовались или до сих пор \
используются **композитные операции**, содержащие внутри себя кубики вида "echo secret" — то есть кубики, выдающий секрет (токен, пароли, ключи доступа) на выход кубика. Использование таких кубиков, \
напрямую или через композитные операции, опасно — токены "светятся" в выводах или логах и доступны неопределённому кругу лиц.

Вот пример использования кубика в одном из инстансов твоего графа: https://nirvana.yandex-team.ru/flow/{workflowId}/{ownerWorkflowInstanceId}/graph/FlowchartBlockOperation/{blockId}

Моя задача — добиться, чтобы все графы перестали использовать такие кубики, чтобы существующие утечки прекратились, и безболезненно удалить все существующие кубики, чтобы новых утечек не появлялось.

====Необходимо подготовить граф к удалению кубиков "echo secret"
В случае с твоим графом — нужно обновить "плохие" композитные операции до новой версии, которые уже не содержат внутри себя кубиков "echo secret".

((https://nirvana.yandex-team.ru/flow/{relevant_workflowId} ссылка на граф))
((https://nirvana.yandex-team.ru/flow/{workflowId}/{ownerWorkflowInstanceId}/graph/FlowchartBlockOperation/{blockId} пример использования кубика в композитной операции))


======Прошу сделать следующее:
0. Дождаться, когда все авторы композитных операций выпустят новые безопасные версии. Только после этого робот добавит тебя в тикет, и ты сможешь его увидеть. **//=вы находитесь здесь=//**
1. **Ознакомься ((https://wiki.yandex-team.ru/privacy_office/echo-chainsaw/do_not_bring_secrets_to_output/ с памяткой))**, объясняющей почему кубики "echo secret" использовать нельзя.
2. Посмотри на то, **как граф используется //сейчас//**.
3. Тикет **можно закрыть** сразу и ничего не делать, если:
  * Граф давным давно заброшен и не собирается снова запускаться.
  * Главный инстанс (последний инстанс или инстанс, который используется для регулярного запуска реакций) уже не использует композитные операции, содержащие внутри "echo secret" — граф использовал \
такие кубики раньше, но сейчас уже не использует.
4. Иначе, граф используется сейчас или на нём завязаны регулярные процессы, и в этих процессах используются композитные операции с кубиками "echo secret". Тогда все **"плохие" композитные операции \
необходимо обновить**, чтобы не использовались кубики "echo secret" и не компрометировались секреты. Чтобы понять, какие композитные операции плохие, придётся посмотреть на главный инстанс "вглубь": \
посмотреть на все композитные операции в инстансе, внутри всех композитных операции посмотреть на все композитные, и так далее; если на каком-то из уровней вложенности окажется кубик вида \
"echo secret" — вам нужно обновить в своём графе самую "внешнюю" композитную операцию. В новых версиях композитных операций могла поменяться логика использования, поэтому на подготовку графа \
к обновлению кубика может уйти некоторое время.
5. Как только все "плохие" композитные операции будут обновлены, и будущее удаление кубиков "echo secret" не поломает процессы в этих операциях — **закрой тикет**. Это важно — каждый тикет с графом \
блокирует задачу по удалению старых версий композитных операций, которые граф использует. Старые версии композитных операций будут удалены строго после закрытия всех задач-блокеров.
---
Спасибо!

#|
|| workflowId| %%{relevant_workflowId}%%||
|#
'''

legacy_hitman_comment_template = '''
Привет! Хочу дополнительно отметить, что граф генерирует инстансы в других воркфлоу через Hitman.
#|
|| Оригинальный граф| %%{relevant_workflowId}%%| https://nirvana.yandex-team.ru/flow/{relevant_workflowId}||
|| Пример сгенерированного через Hitman графа| %%{workflowId}%%| https://nirvana.yandex-team.ru/flow/{workflowId}||
|#'''


def update_tickets(in1, in2, token_st, debug=None, ignore_subgraphs=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
    else:
        queue_name = "CHSWCOMPFIX".lower()

    workflow_owners = get_workflow_owners(in2)

    workflow_seen = []
    for incident in in1:
        if not incident['is_composite']:
            # print('is not composite!')
            continue

        workflowId = incident['workflowId']

        compositeOperationId = incident['compositeOperationId']
        if ignore_subgraphs and compositeOperationId is None:
            continue

        if workflowId in workflow_seen:
            continue

        relevant_workflowId = incident['workflowId']
        if incident['is_legacy_hitman']:
            print('legacy hitman!')
            relevant_workflowId = incident['legacy_hitman_workflow_id']
            time.sleep(4)  # на всякий случай

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {queue_name} Mark: {relevant_workflowId}"
            }
        )
        assert len(r) <= 1, f"🧑‍🚒found >1 tickets!🚒 {r[0]['key'], r[1]['key']}"

        if len(r) == 0:
            print("CREATE TICKET")

            summary = summary_template.format(relevant_workflowId=relevant_workflowId)
            description = description_template.format(relevant_workflowId=relevant_workflowId, **incident)
            ticket = soft_request(
                st_host+'issues',
                token_st,
                json={
                    "queue": queue_name,
                    "type": 'incident',
                    "priority": 'normal',
                    "summary": summary,
                    "description": description,
                    "assignee": None,
                    "access": 'anatoliy-ch',
                    "mark": relevant_workflowId,
                    "employees": workflow_owners[relevant_workflowId]
                },
                type='post'
            )
        else:
            print("SAVE TICKET")
            ticket = r[0]

        ticket_key = ticket['key']

        if incident['is_legacy_hitman'] and "is_legacy_hitman" not in ticket.get('tags', []):
            print("ADD COMMENT")
            soft_request(
                st_host+f'issues/{ticket_key}/comments',
                token_st,
                type='post',
                json={
                    "text": legacy_hitman_comment_template.format(**incident, relevant_workflowId=relevant_workflowId),
                }
            )
            print("ADD TAG")
            soft_request(
                st_host+f'issues/{ticket_key}',
                token_st,
                type='patch',
                json={
                    "tags": {"add": ["is_legacy_hitman"]}
                }
            )

        if set(get_employees_logins(ticket.get('employees', []))) != set(workflow_owners[relevant_workflowId]):
            print('Employees are not actual!')
            soft_request(
                st_host+f'issues/{ticket_key}',
                token_st,
                type='patch',
                json={
                    "employees": {
                        "remove": get_employees_logins(ticket.get('employees', [])),
                        "add": workflow_owners[relevant_workflowId]
                    }
                }
            )

        print(ticket_key)
        workflow_seen.append(workflowId)


def update_connections(in1, in2, token_st, debug=None, ignore_subgraphs=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
        compupdate_queue_name = "CH".lower()
    else:
        queue_name = "CHSWCOMPFIX".lower()
        compupdate_queue_name = "CHSWCOMPUPDATE".lower()

    relevant_workflow_composite_operation_seen = []

    for incident in in1:
        if not incident['is_composite']:
            # print('is not composite!')
            continue

        compositeOperationId = incident['compositeOperationId']
        if ignore_subgraphs and compositeOperationId is None:
            continue

        relevant_workflowId = incident['workflowId']
        if incident['is_legacy_hitman']:
            print('legacy hitman!')
            relevant_workflowId = incident['legacy_hitman_workflow_id']
            time.sleep(4)  # на всякий случай

        relevant_workflow_composite_operation = (relevant_workflowId, compositeOperationId)

        if relevant_workflow_composite_operation in relevant_workflow_composite_operation_seen:
            continue

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {queue_name} Mark: {relevant_workflowId}"
            }
        )
        assert len(r) == 1, f"🧑‍🚒found {len(r)}≠1 tickets!🚒 {queue_name}:{relevant_workflowId}"

        ticket = r[0]
        ticket_key = ticket['key']

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {compupdate_queue_name} Mark: {compositeOperationId}"
            }
        )
        assert len(r) == 1, f"🧑‍🚒found {len(r)}≠1 tickets!🚒 {compupdate_queue_name}:{compositeOperationId}"
        compupdate_ticket_key = r[0]['key']
        r = soft_request(
            st_host+f'issues/{ticket_key}/links',
            token_st,
            type="post",
            json={
                "relationship": "depends on",
                "issue": compupdate_ticket_key
            },
            status_whitelist=[201, 200, 422]  # 422 это когда связь уже есть
        )
        if 'errors' in r:
            print(f"{compositeOperationId} is already blocking {relevant_workflowId}! {compupdate_ticket_key} -> {ticket_key}")
        else:
            print(f"new link! {compupdate_ticket_key} -> {ticket_key}")

        print(ticket_key)
        relevant_workflow_composite_operation_seen.append(relevant_workflow_composite_operation)


@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    if param1 == '':
        params = {}
    else:
        params = json.loads(param1)

    # I создать по тикету на каждый граф с композитным кубиком
    print("PART 1/2!")
    update_tickets(in1, in2, token1, **params)

    # II создать все нужные связи по таблице инцидентов
    print("PART 2/2!")
    time.sleep(45)
    update_connections(in1, in2, token1, **params)

    return {
        "out1": None,
        "out2": None,
        "out3": None
    }
