from privacy_office.lib.soft_request.main import soft_request, st_host
from privacy_office.lib.nirvana_combine.main import combine_this

import json


def get_composite_operation_owners(in2):
    composite_operation_owners = {}
    for line in in2:
        composite_operation_owners.setdefault(line["id"], [])
        composite_operation_owners[line["id"]].append(line["created_by_id"])
    return composite_operation_owners


def get_composite_operation_names(in2):
    composite_operation_names = {}
    for line in in2:
        composite_operation_names.setdefault(line["id"], [])
        composite_operation_names[line["id"]].append(line["name"])
    return composite_operation_names


def get_employees_logins(ticket_employees):
    return list(employee['id'] for employee in ticket_employees)

summary_template = 'Подготовить композитную операцию к удалению кубиков: {compositeOperationId}'

description_template = '''
Привет!

Я вижу, что ты являешься владельцем композитной Nirvana-операции ((https://nirvana.yandex-team.ru/operation/{compositeOperationId} {composite_operation_name})). \
В графе этой композитной операции используются кубики вида "echo secret" — то есть кубики, выдающий секрет (токен, пароли, ключи доступа) на выход кубика. \
Использование таких кубиков опасно — токены "светятся" в выводах или логах и доступны неопределённому кругу лиц.

Моя задача — добиться, чтобы все графы (в частности — все графы композитных операций) перестали использовать такие кубики, чтобы существующие утечки прекратились, \
и безболезненно удалить все существующие кубики, чтобы новых утечек не появлялось.

====Необходимо подготовить граф композитной операции к удалению кубиков "echo secret"

((https://nirvana.yandex-team.ru/operation/{compositeOperationId} ссылка на граф композитной операции))


======Прошу сделать следующее:
1. **Ознакомься ((https://wiki.yandex-team.ru/privacy_office/echo-chainsaw/do_not_bring_secrets_to_output/ с памяткой))**, \
объясняющей почему кубики "echo secret" использовать нельзя.
2. Перейди на страницу своей операции ((https://nirvana.yandex-team.ru/operation/{compositeOperationId} по ссылке)).
3. Переведи кубик в статус **optional deprecated**: ((https://wiki.yandex-team.ru/privacyoffice/echo-chainsaw/deprecate-cube/ **гайд**)).
4. Посмотри на то, **как операция используется //сейчас//** — \
((https://nirvana.yandex-team.ru/instances/1/filter?@filterName=All&blockType=ExprBlockTypeEquals({compositeOperationId})&@sorting=created%3Atrue история использований)).
5. Тикет **можно закрыть** и больше ничего не делать, если композитная операция давным давно заброшена, её никто не использует и не собирается снова использовать.
4. Иначе, на композитной операции завязаны регулярные процессы. Тогда **граф композитного кубика нужно переделать**, \
выпустив новую версию, в которых не используются кубики "echo secret" и не компрометируются токены. \
Как правило, секреты компрометируются для того, чтобы подать токен как опцию в кубик, который из-коробки не поддерживает в себе секреты. \
В таком стоит поискать аналоги кубика, которые секреты поддерживают.
5. Как только новая версия операции будет готова — **закрой тикет**. Этот тикет блокирует задачи, \
в которых я прошу владельцев графов обновить твой кубик до безопасной версии.

Через некоторое время (когда все воркфлоу, где используется твоя композитная операция, обновят её до безопасной версии) \
мы попросим полностью закрыть кубик (mandatory deprecated). Об этом мы сообщим отдельно.

---
Спасибо!

#|
|| compositeOperationId| %%{compositeOperationId}%%||
|| name| %%{composite_operation_name}%%||
|#
'''


def update_tickets(in1, in2, token_st, debug=None, ignore_subgraphs=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
    else:
        queue_name = "CHSWCOMPUPDATE".lower()

    composite_operation_owners = get_composite_operation_owners(in2)
    composite_operation_names = get_composite_operation_names(in2)

    composite_operation_seen = []
    for incident in in1:
        if not incident['is_composite']:
            # print('is not composite!')
            continue

        compositeOperationId = incident['compositeOperationId']
        if ignore_subgraphs and compositeOperationId is None:
            continue

        composite_operation_name = composite_operation_names[compositeOperationId][0]

        if compositeOperationId in composite_operation_seen:
            continue

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {queue_name} Mark: {compositeOperationId}"
            }
        )
        assert len(r) <= 1, f"🧑‍🚒found >1 tickets!🚒 {r[0]['key'], r[1]['key']}"

        if len(r) == 0:
            print("CREATE TICKET")

            summary = summary_template.format(compositeOperationId=compositeOperationId)
            description = description_template.format(compositeOperationId=compositeOperationId, composite_operation_name=composite_operation_name)
            ticket = soft_request(
                st_host+'issues',
                token_st,
                json={
                    "queue": queue_name,
                    "type": 'incident',
                    "priority": 'normal',
                    "summary": summary,
                    "description": description,
                    "assignee": None,
                    "access": 'anatoliy-ch',
                    "mark": compositeOperationId,
                    "employees": composite_operation_owners[compositeOperationId]
                },
                type='post'
            )
        else:
            print("SAVE TICKET")
            ticket = r[0]

        ticket_key = ticket['key']

        if set(get_employees_logins(ticket.get('employees', []))) != set(composite_operation_owners[compositeOperationId]):
            print('Employees are not actual!')
            soft_request(
                st_host+f'issues/{ticket_key}',
                token_st,
                type='patch',
                json={
                    "employees": {
                        "remove": get_employees_logins(ticket.get('employees', [])),
                        "add": composite_operation_owners[compositeOperationId]
                    }
                }
            )

        print(ticket_key)
        composite_operation_seen.append(compositeOperationId)


@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    if param1 == '':
        params = {}
    else:
        params = json.loads(param1)

    update_tickets(in1, in2, token1, **params)

    return {
        "out1": None,
        "out2": None,
        "out3": None
    }
