from privacy_office.lib.soft_request.main import soft_request, st_host
from privacy_office.lib.nirvana_combine.main import combine_this

import json
import time


def get_employees_logins(ticket_employees):
    return list(employee['id'] for employee in ticket_employees)

summary_template = 'Удалить операцию: {operationId}'

description_template = '''
Привет, снова!

В прошлом тикете я просил перевести пометить твой кубик "echo secret" как небезопасный и перевести его в статус optional deprecate, \
так как кубик является небезопасным.

Теперь пора удалить кубик, чтобы остановить будущие утечки.

((https://nirvana.yandex-team.ru/operation/{operationId} ссылка на кубик))


======Прошу сделать следующее:
0. Пометить кубик как опасный и перевести его в статус optional deprecate. Дождаться, когда все пользователи кубика переделают свои графы, \
чтобы кубик больше не использовался. **//=вы находитесь здесь=//**
1. Переведи все версии кубика из статуса **optional deprecated** в статус **mandatory deprecated**: \
((https://wiki.yandex-team.ru/privacy_office/echo-chainsaw/mandatory-deprecate-cube/ **гайд**)).
2. Как только все версии будут удалены (mandatory deprecated) — **закрой тикет**.

---
Спасибо!

#|
|| operationId| %%{operationId}%%||
|| name| %%{operation_name}%%||
|#
'''


def update_tickets(in1, in2, token_st, debug=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
    else:
        queue_name = "CHSWDELETE".lower()

    operation_seen = []
    for line in in2:
        operationId = line['id']
        assert operationId not in operation_seen, f"🧑‍🚒>1 line with the same id!🚒 {operationId}"

        operation_owners = [line['created_by_id']]
        operation_name = line['name']

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {queue_name} Mark: {operationId}"
            }
        )

        assert len(r) <= 1, f"🧑‍🚒found >1 tickets!🚒 {r[0]['key'], r[1]['key']}"

        if len(r) == 0:
            print("CREATE TICKET")

            summary = summary_template.format(operationId=operationId)
            description = description_template.format(operationId=operationId, operation_name=operation_name)
            ticket = soft_request(
                st_host+'issues',
                token_st,
                json={
                    "queue": queue_name,
                    "type": 'incident',
                    "priority": 'normal',
                    "summary": summary,
                    "description": description,
                    "assignee": None,
                    "access": 'anatoliy-ch',
                    "mark": operationId,
                    "employees": operation_owners
                },
                type='post'
            )
        else:
            print("SAVE TICKET")
            ticket = r[0]

        ticket_key = ticket['key']

        if set(get_employees_logins(ticket.get('employees', []))) != set(operation_owners):
            print('Employees are not actual!')
            soft_request(
                st_host+f'issues/{ticket_key}',
                token_st,
                type='patch',
                json={
                    "employees": {
                        "remove": get_employees_logins(ticket.get('employees', [])),
                        "add": operation_owners
                    }
                }
            )

        print(ticket_key)
        operation_seen.append(operationId)


def update_connections(in1, in2, token_st, debug=None, ignore_subgraphs=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
        fix_queue_name = "CH".lower()
        compfix_queue_name = "CH".lower()
    else:
        queue_name = "CHSWDELETE".lower()
        fix_queue_name = "CHSWFIX".lower()
        compfix_queue_name = "CHSWCOMPFIX".lower()

    relevant_workflow_operation_is_composite_seen = []
    for incident in in1:

        operationId = incident['operationId']
        is_composite = incident['is_composite']

        compositeOperationId = incident['compositeOperationId']
        if ignore_subgraphs and is_composite and compositeOperationId is None:
            continue

        relevant_workflowId = incident['workflowId']
        if incident['is_legacy_hitman']:
            print('legacy hitman!')
            relevant_workflowId = incident['legacy_hitman_workflow_id']

        relevant_workflow_operation_is_composite = (relevant_workflowId, operationId, is_composite)

        if relevant_workflow_operation_is_composite in relevant_workflow_operation_is_composite_seen:
            continue

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {queue_name} Mark: {operationId}"
            }
        )
        assert len(r) == 1, f"🧑‍🚒found {len(r)}≠1 tickets!🚒 {queue_name}:{operationId}"

        ticket = r[0]
        ticket_key = ticket['key']

        if is_composite:
            relevant_queue_name = compfix_queue_name
        else:
            relevant_queue_name = fix_queue_name

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {relevant_queue_name} Mark: {relevant_workflowId}"
            }
        )
        assert len(r) == 1, f"🧑‍🚒found {len(r)}≠1 tickets!🚒 {relevant_workflowId}:{relevant_workflowId}"
        relevant_ticket_key = r[0]['key']
        r = soft_request(
            st_host+f'issues/{ticket_key}/links',
            token_st,
            type="post",
            json={
                "relationship": "depends on",
                "issue": relevant_ticket_key
            },
            status_whitelist=[201, 200, 422]  # 422 это когда связь уже есть
        )
        if 'errors' in r:
            print(f"{relevant_workflowId} is already blocking {operationId}! {relevant_ticket_key} -> {ticket_key}")
        else:
            print(f"new link! {relevant_ticket_key} -> {ticket_key}")

        print(ticket_key)
        relevant_workflow_operation_is_composite_seen.append(relevant_workflow_operation_is_composite)


@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    if param1 == '':
        params = {}
    else:
        params = json.loads(param1)

    # I создать по тикету на каждый граф с кубиком
    print("PART 1/2!")
    update_tickets(in1, in2, token1, **params)

    # II создать все нужные связи по таблице инцидентов
    print("PART 2/2!")
    time.sleep(45)
    update_connections(in1, in2, token1, **params)

    return {
        "out1": None,
        "out2": None,
        "out3": None
    }
