from privacy_office.lib.soft_request.main import soft_request, st_host
from privacy_office.lib.nirvana_combine.main import combine_this

import json


def get_employees_logins(ticket_employees):
    return list(employee['id'] for employee in ticket_employees)


summary_template = 'Пометить кубик как опасный: {operationId}'

description_template = '''
Привет!

Я вижу, что ты являешься владельцем кубика ((https://nirvana.yandex-team.ru/operation/{operationId} {operation_name})). \
Этот кубик выдаёт секрет (токен, пароли, ключи доступа) на выход кубика. Использование таких кубиков опасно — токены "светятся" \
в выводах или логах и доступны неопределённому кругу лиц.

Моя задача — добиться, чтобы все графы перестали использовать такие кубики, чтобы существующие утечки прекратились, \
и безболезненно удалить все существующие кубики, чтобы новых утечек не появлялось.

====Необходимо подготовить кубик к его будущему удалению

((https://nirvana.yandex-team.ru/operation/7d2e344b-9001-4e71-be76-a1f1ad620359 ссылка на кубик))

======Прошу сделать следующее:
1. **Ознакомься ((https://wiki.yandex-team.ru/privacy_office/echo-chainsaw/do_not_bring_secrets_to_output/ с памяткой))**, \
объясняющий почему кубики "echo secret" использовать нельзя.
2. Перейди на страницу своего кубика ((https://nirvana.yandex-team.ru/operation/{operationId} по ссылке)).
3. Переведи кубик в статус **optional deprecated** и **пометь его как небезопасный** (NOT SAFE, DO NOT USE): \
((https://wiki.yandex-team.ru/privacyoffice/echo-chainsaw/deprecate-cube/ **гайд**)).
4. Как только всё будет сделано — **закрой тикет**.

Через некоторое время (когда все воркфлоу, где используется твой кубик, будут исправлены) мы попросим полностью \
закрыть кубик (**mandatory deprecated**). Об этом мы сообщим отдельно.
---
Спасибо!

#|
|| operationId| %%{operationId}%%||
|| name| %%{operation_name}%%||
|#
'''


def update_tickets(in1, in2, token_st, debug=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
    else:
        queue_name = "CHSWDEPRECATE".lower()

    operation_seen = []
    for line in in2:
        operationId = line['id']
        assert operationId not in operation_seen, f"🧑‍🚒>1 line with the same id!🚒 {operationId}"

        operation_owners = [line['created_by_id']]
        operation_name = line['name']

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {queue_name} Mark: {operationId}"
            }
        )

        assert len(r) <= 1, f"🧑‍🚒found >1 tickets!🚒 {r[0]['key'], r[1]['key']}"

        if len(r) == 0:
            print("CREATE TICKET")

            summary = summary_template.format(operationId=operationId)
            description = description_template.format(operationId=operationId, operation_name=operation_name)
            ticket = soft_request(
                st_host+'issues',
                token_st,
                json={
                    "queue": queue_name,
                    "type": 'incident',
                    "priority": 'normal',
                    "summary": summary,
                    "description": description,
                    "assignee": None,
                    "access": 'anatoliy-ch',
                    "mark": operationId,
                    "employees": operation_owners
                },
                type='post'
            )
        else:
            print("SAVE TICKET")
            ticket = r[0]

        ticket_key = ticket['key']

        if set(get_employees_logins(ticket.get('employees', []))) != set(operation_owners):
            print('Employees are not actual!')
            soft_request(
                st_host+f'issues/{ticket_key}',
                token_st,
                type='patch',
                json={
                    "employees": {
                        "remove": get_employees_logins(ticket.get('employees', [])),
                        "add": operation_owners
                    }
                }
            )

        print(ticket_key)
        operation_seen.append(operationId)


@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    if param1 == '':
        params = {}
    else:
        params = json.loads(param1)

    update_tickets(in1, in2, token1, **params)

    return {
        "out1": None,
        "out2": None,
        "out3": None
    }
