from privacy_office.lib.soft_request.main import soft_request, st_host
from privacy_office.lib.nirvana_combine.main import combine_this

import json
import time


def get_workflow_owners(in2):
    workflow_owners = {}
    for line in in2:
        workflow_owners.setdefault(line["workflowId"], [])
        workflow_owners[line["workflowId"]].append(line["workflowOwner"])
    return workflow_owners


def get_employees_logins(ticket_employees):
    return list(employee['id'] for employee in ticket_employees)

summary_template = 'Подготовить граф к удалению кубиков: {relevant_workflowId}'

description_template = '''
**Важно!** Если ты не являешься релевантным исполнителем, и робот добавил тебя по ошибке — обязательно отпишись об этом в комментариях, и при возможности — подскажи к кому я могу обратиться.

---

Привет!

Я вижу, что ты являешься одним из пользователей Nirvana-графа ((https://nirvana.yandex-team.ru/flow/{relevant_workflowId} {relevant_workflowId})). \
В этом воркфлоу использовались или до сих пор используются кубики вида "echo secret" — то есть кубики, выдающий секрет (токен, пароли, ключи доступа) на выход кубика. \
Использование таких кубиков опасно — токены "светятся" в выводах или логах и доступны неопределённому кругу лиц.

Вот пример использования кубика в одном из инстансов твоего графа: https://nirvana.yandex-team.ru/flow/{workflowId}/{ownerWorkflowInstanceId}/graph/FlowchartBlockOperation/{blockId}

Моя задача — добиться, чтобы все графы перестали использовать такие кубики, чтобы существующие утечки прекратились, и безболезненно удалить все существующие кубики, чтобы новых утечек не появлялось.

====Необходимо подготовить граф к удалению кубиков "echo secret"

((https://nirvana.yandex-team.ru/flow/{relevant_workflowId} ссылка на граф))
((https://nirvana.yandex-team.ru/flow/{workflowId}/{ownerWorkflowInstanceId}/graph/FlowchartBlockOperation/{blockId} пример использования кубика))


======Прошу сделать следующее:
1. **Ознакомься ((https://wiki.yandex-team.ru/privacy_office/echo-chainsaw/do_not_bring_secrets_to_output/ с памяткой))**, объясняющей почему кубики "echo secret" использовать нельзя.
2. Посмотри на то, **как граф используется //сейчас//**.
3. Тикет **можно закрыть** сразу и ничего не делать, если:
  * Граф давным давно заброшен и не собирается снова запускаться.
  * Главный инстанс (последний инстанс или инстанс, который используется для регулярного запуска реакций) уже не использует кубики "echo secret" — граф использовал такие кубики раньше, \
но сейчас уже не использует.
4. Иначе, граф используется сейчас или на нём завязаны регулярные процессы, и в этих процессах используются кубики "echo secret". Тогда **граф необходимо переделать**, \
чтобы не использовались кубики "echo secret" и не компрометировались секреты. Как правило, секреты компрометируются для того, чтобы подать токен как опцию в кубик, \
который из-коробки не поддерживает в себе секреты. В таком стоит поискать аналоги кубика, которые секреты поддерживают.
5. Как только граф будет готов к будущему удалению кубиков — **закрой тикет**. Это важно — каждый тикет с графом блокирует задачу по удалению кубиков, которые граф использует. \
Сам кубик будет удалён строго после закрытия всех задач-блокеров.
---
Спасибо!

#|
|| workflowId| %%{relevant_workflowId}%%||
|#
'''

legacy_hitman_comment_template = '''
Привет! Хочу дополнительно отметить, что граф генерирует инстансы в других воркфлоу через Hitman.
#|
|| Оригинальный граф| %%{relevant_workflowId}%%| https://nirvana.yandex-team.ru/flow/{relevant_workflowId}||
|| Пример сгенерированного через Hitman графа| %%{workflowId}%%| https://nirvana.yandex-team.ru/flow/{workflowId}||
|#'''


def update_tickets(in1, in2, token_st, debug=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
    else:
        queue_name = "CHSWFIX".lower()

    workflow_owners = get_workflow_owners(in2)

    workflow_seen = []
    for incident in in1:
        workflowId = incident['workflowId']
        relevant_workflowId = incident['workflowId']
        if incident['is_legacy_hitman']:
            print('legacy hitman!')
            relevant_workflowId = incident['legacy_hitman_workflow_id']
            time.sleep(4)  # на всякий случай

        if workflowId in workflow_seen:
            continue

        if incident['is_composite']:
            # print('is composite!')
            continue

        r = soft_request(
            st_host+'issues/',
            token_st,
            params={
                "query": f"Queue: {queue_name} Mark: {relevant_workflowId}"
            }
        )
        assert len(r) <= 1, f"🧑‍🚒found >1 tickets!🚒 {r[0]['key'], r[1]['key']}"

        if len(r) == 0:
            print("CREATE TICKET")

            summary = summary_template.format(relevant_workflowId=relevant_workflowId)
            description = description_template.format(**incident, relevant_workflowId=relevant_workflowId)
            ticket = soft_request(
                st_host+'issues',
                token_st,
                json={
                    "queue": queue_name,
                    "type": 'incident',
                    "priority": 'normal',
                    "summary": summary,
                    "description": description,
                    "assignee": None,
                    "access": 'anatoliy-ch',
                    "mark": relevant_workflowId,
                    "employees": workflow_owners[relevant_workflowId]
                },
                type='post'
            )
        else:
            print("save ticket")
            ticket = r[0]

        ticket_key = ticket['key']

        if incident['is_legacy_hitman'] and "is_legacy_hitman" not in ticket.get('tags', []):
            print("ADD COMMENT")
            soft_request(
                st_host+f'issues/{ticket_key}/comments',
                token_st,
                type='post',
                json={
                    "text": legacy_hitman_comment_template.format(**incident, relevant_workflowId=relevant_workflowId),
                }
            )
            print("ADD TAG")
            soft_request(
                st_host+f'issues/{ticket_key}',
                token_st,
                type='patch',
                json={
                    "tags": {"add": ["is_legacy_hitman"]}
                }
            )

        if set(get_employees_logins(ticket.get('employees', []))) != set(workflow_owners[relevant_workflowId]):
            print('Employees are not actual!')
            soft_request(
                st_host+f'issues/{ticket_key}',
                token_st,
                type='patch',
                json={
                    "employees": {
                        "remove": get_employees_logins(ticket.get('employees', [])),
                        "add": workflow_owners[relevant_workflowId]
                    }
                }
            )

        print(ticket_key)
        workflow_seen.append(workflowId)


@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    if param1 == '':
        params = {}
    else:
        params = json.loads(param1)

    update_tickets(in1, in2, token1, **params)

    return {
        "out1": None,
        "out2": None,
        "out3": None
    }
