# ПОКА НЕ РЕШЁН БАГ С НЕСУЩЕСТВУЮЩИМ ВЛАДЕЛЬЦЕМ ТОКЕНА

from privacy_office.lib.soft_request.main import soft_request, st_host, staff_host
from privacy_office.lib.nirvana_combine.main import combine_this

import json
import time


def get_employees_logins(ticket_employees):
    return list(employee['id'] for employee in ticket_employees)


def is_user_fake(username, token):
    return soft_request(
        staff_host+'persons',
        token,
        params={
            "login": username
        }
    )['result'] == []

summary_template = 'Отозвать скомпрометированный токен: {sha1}'

description_template = '''
Привет!
Я вижу, что ты являешься владельцем токена с sha1: %%{sha1}%%.
К сожалению, твой токен был скомпрометирован. Он выглядит как-то так: %%{anonymized}%%.

======Что случилось?
- Твой токен был содержимым некоторого Нирвана-секрета.
- Этот Нирвана-секрет использовался в Нирване как опция в одном из кубиков в одном из инстансов в одном из графов.
- Проблема в том, что используемый кубик был кубиком типа "echo secret" — \
то есть кубиком, выдающим содержимое секрета на выход кубика.
- Я увидел выхлоп этого кубика, и ((https://wiki.yandex-team.ru/security/secrets/ant-secret/ ant-secret)) \
распознал в выхлопе твой токен.

Моя задача — добиться, чтобы все графы перестали использовать такие кубики, чтобы существующие утечки прекратились, \
и безболезненно устранить последствия всех утечек.

====Необходимо отозвать скомпрометированный токен

%%{oauth_client_id}%% — client_id твоего токена.
%%{tail}%% — последние 4 символа твоего токена.

======Прошу сделать следующее:
0. Дождаться, когда все графы, которые из-за кубиков echo secret компрометировали твой токен, перестали это делать \
(= когда все задачи-блокеры будут решены). **//=вы находитесь здесь=//**
1. **Ознакомься ((https://wiki.yandex-team.ru/privacy_office/echo-chainsaw/do_not_bring_secrets_to_output/ с памяткой))**, \
объясняющий почему кубики "echo secret" использовать нельзя.
2. Отзови токен, предварительно проверив, что он ничего не сломает: \
((https://wiki.yandex-team.ru/privacyoffice/echo-chainsaw/revoke-token/ **гайд**)).
3. Как только токен в Nirvana-секрете будет отозван — **закрой тикет**.

---
Спасибо!

{table}
'''

fake_owner_comment_template = '''
Привет! Хочу дополнительно отметить, что владельцем токена является фейковый юзер. \
Настоящего ответственного придётся искать самостоятельно.
#|
|| secret_users| %%{secret_users}%%||
|#'''


def update_tickets(in1, in2, token_st, debug=None, ignore_subgraphs=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
    else:
        queue_name = "CHSWREVOKE".lower()

    token_seen = []
    for incident in in1:
        compositeOperationId = incident['compositeOperationId']
        if ignore_subgraphs and incident['is_composite'] and compositeOperationId is None:
            continue

        for token in incident['token_info']:

            token_sha1 = token['sha1']

            if token_sha1 in token_seen:
                continue

            token_owners = [token['secret_users']]
            is_token_owner_fake = is_user_fake(token['secret_users'], token_st)
            if is_token_owner_fake:
                token_owners = []

            r = soft_request(
                st_host+'issues/',
                token_st,
                params={
                    "query": f"Queue: {queue_name} Mark: {token_sha1}"
                }
            )

            assert len(r) <= 1, f"🧑‍🚒found >1 tickets!🚒 {r[0]['key'], r[1]['key']}"

            if len(r) == 0:
                print("CREATE TICKET")

                table = '\n'.join(
                    ["#|"]+
                    [f"|| {key} | %%{token[key] if token[key] != '' else '-//-'}%%||" for key in token]+
                    ["|#"]
                )

                summary = summary_template.format(**token)
                description = description_template.format(table=table, **token)
                ticket = soft_request(
                    st_host+'issues',
                    token_st,
                    json={
                        "queue": queue_name,
                        "type": 'incident',
                        "priority": 'normal',
                        "summary": summary,
                        "description": description,
                        "assignee": None,
                        "access": 'anatoliy-ch',
                        "mark": token_sha1,
                        "employees": token_owners
                    },
                    type='post'
                )
            else:
                print("SAVE TICKET")
                ticket = r[0]

            ticket_key = ticket['key']

            if set(get_employees_logins(ticket.get('employees', []))) != set(token_owners):
                print('Employees are not actual!')
                soft_request(
                    st_host+f'issues/{ticket_key}',
                    token_st,
                    type='patch',
                    json={
                        "employees": {
                            "remove": get_employees_logins(ticket.get('employees', [])),
                            "add": token_owners
                        }
                    }
                )

            if is_token_owner_fake and "is_token_owner_fake" not in ticket.get('tags', []):
                print("ADD COMMENT")
                soft_request(
                    st_host+f'issues/{ticket_key}/comments',
                    token_st,
                    type='post',
                    json={
                        "text": fake_owner_comment_template.format(**token),
                    }
                )
                print("ADD TAG")
                soft_request(
                    st_host+f'issues/{ticket_key}',
                    token_st,
                    type='patch',
                    json={
                        "tags": {"add": ["is_token_owner_fake"]}
                    }
                )

            print(ticket_key)
            token_seen.append(token_sha1)


def update_connections(in1, in2, token_st, debug=None, ignore_subgraphs=None, **kwargs):
    if debug:
        queue_name = "CH".lower()
        change_queue_name = "CH".lower()
    else:
        queue_name = "CHSWREVOKE".lower()
        change_queue_name = "CHSWCHANGE".lower()

    secret_token_seen = []
    for incident in in1:
        compositeOperationId = incident['compositeOperationId']
        if ignore_subgraphs and incident['is_composite'] and compositeOperationId is None:
            continue

        for token in incident['token_info']:
            for secret in incident['secret_info']:
                secret_id = secret['secret_id']
                token_sha1 = token['sha1']
                secret_token = (secret_id, token_sha1)

                if secret_token in secret_token_seen:
                    continue

                r = soft_request(
                    st_host+'issues/',
                    token_st,
                    params={
                        "query": f"Queue: {queue_name} Mark: {token_sha1}"
                    }
                )
                assert len(r) == 1, f"🧑‍🚒found {len(r)}≠1 tickets!🚒 {queue_name}:{secret_id}"

                ticket = r[0]
                ticket_key = ticket['key']

                r = soft_request(
                    st_host+'issues/',
                    token_st,
                    params={
                        "query": f"Queue: {change_queue_name} Mark: {secret_id}"
                    }
                )
                assert len(r) == 1, f"🧑‍🚒found {len(r)}≠1 tickets!🚒 {change_queue_name}:{secret_id}"
                change_ticket_key = r[0]['key']
                r = soft_request(
                    st_host+f'issues/{ticket_key}/links',
                    token_st,
                    type="post",
                    json={
                        "relationship": "depends on",
                        "issue": change_ticket_key
                    },
                    status_whitelist=[201, 200, 422]  # 422 это когда связь уже есть
                )

                if 'errors' in r:
                    print(f"{token_sha1} is already blocking {secret_id}! {change_ticket_key} -> {ticket_key}")
                else:
                    print(f"new link! {change_ticket_key} -> {ticket_key}")

                print(ticket_key)
                secret_token_seen.append(secret_token)


@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    if param1 == '':
        params = {}
    else:
        params = json.loads(param1)

    # I создать по тикету на каждый граф с кубиком
    print("PART 1/2!")
    update_tickets(in1, in2, token1, **params)

    # II создать все нужные связи по таблице инцидентов
    print("PART 2/2!")
    time.sleep(45)
    update_connections(in1, in2, token1, **params)

    return {
        "out1": None,
        "out2": None,
        "out3": None
    }
