from privacy_office.lib.soft_request.main import staff_host, achievment_host, soft_request


def give_achievment(username, achievment_id, token_yt, verbose=False):
    user_id = soft_request(
        staff_host + f'persons?login={username}',
        token_yt
    )['result'][0]['id']

    is_already_has_achievment = soft_request(
        achievment_host + 'given/',
        token_yt,
        type='get',
        params={
            "person.id": user_id,
            "achievement.id": achievment_id
        }
    )['total'] != 0

    if is_already_has_achievment:
        if verbose:
            print(f'{username} already has achievment!')
    else:
        soft_request(
            achievment_host + 'given/',
            token_yt,
            type='post',
            json={
                "person.id": user_id,
                "achievement.id": achievment_id,
                "level": -1
            }
        )
        if verbose:
            print(f'🆕 {username} gave achievment!')
