# %%
import json
import argparse


# %%
def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--in1', nargs='?')
    parser.add_argument('--in2', nargs='?')
    parser.add_argument('--in3', nargs='?')

    parser.add_argument('--out1')
    parser.add_argument('--out2')
    parser.add_argument('--out3')

    parser.add_argument('--token1')
    parser.add_argument('--token2')
    parser.add_argument('--token3')

    parser.add_argument('--param1')
    parser.add_argument('--param2')
    parser.add_argument('--param3')

    args, unknown = parser.parse_known_args()

    in1 = {}
    if args.in1:
        with open(args.in1, encoding='utf-8') as in1_file:
            in1 = json.load(in1_file)
    in2 = {}
    if args.in2:
        with open(args.in2, encoding='utf-8') as in2_file:
            in2 = json.load(in2_file)
    in3 = {}
    if args.in3:
        with open(args.in3, encoding='utf-8') as in3_file:
            in3 = json.load(in3_file)

    return {
        "in1": in1,
        "in2": in2,
        "in3": in3,

        "token1": args.token1,
        "token2": args.token2,
        "token3": args.token3,

        "param1": args.param1,
        "param2": args.param2,
        "param3": args.param3,
    }, {
        "out1": args.out1,
        "out2": args.out2,
        "out3": args.out3,
    }


# %%
args, out = parse_args()


# %%
def save_results(to_out):
    if type(to_out) != dict:
        return "💩"

    out1 = to_out.setdefault("out1", None)
    out2 = to_out.setdefault("out2", None)
    out3 = to_out.setdefault("out3", None)

    # print('❗️❗️')
    # print(out1, out2, out3)
    # print(out)
    # print('❗️❗️')

    with open(out['out1'], 'w', encoding='utf-8') as out1_file:
        out1_file.write(json.dumps(out1, ensure_ascii=False, indent=4))
    with open(out['out2'], 'w', encoding='utf-8') as out2_file:
        out2_file.write(json.dumps(out2, ensure_ascii=False, indent=4))
    with open(out['out3'], 'w', encoding='utf-8') as out3_file:
        out3_file.write(json.dumps(out3, ensure_ascii=False, indent=4))

    return "🧚‍♀️"


# %%
def combine_this(func):
    def wrapper():
        to_out = func(**args)
        save_results(to_out)
    return wrapper
