from security.secret_search import Searcher
import json
import re


def anonymize_token(text):
    return re.sub('[a-zA-Z0-9]', '?', text[:-4]) + text[-4:]


def recognize_secrets(text, verbose=False):
    secrets = Searcher(valid_only=True).check_blob(text)
    out = []
    for secret in secrets:
        secret_metadata = secret.additional
        secret_metadata["tail"] = secret.secret[-4:]
        secret_metadata["anonymized"] = anonymize_token(secret.secret)
        secret_metadata.pop("secret_validate_url", None)
        if verbose:
            print('💩')
            print(json.dumps(secret_metadata, indent=4))
        out.append(secret_metadata)
    return out
