import requests
import time

import warnings
warnings.filterwarnings("ignore")

st_host = 'https://st-api.yandex-team.ru/v2/'
staff_host = 'https://staff-api.yandex-team.ru/v3/'
staff_gap_host = 'https://staff.yandex-team.ru/gap-api/api/'
nirvana_host = 'https://nirvana.yandex-team.ru/api/public/v1/'
abc_host = 'https://abc-back.yandex-team.ru/api/v4/'
wiki_host = 'https://wiki-api.yandex-team.ru/_api/frontend/'
achievment_host = 'https://staff.yandex-team.ru/api/achievery/'


def get_headers(token):
    return {'Authorization': f'OAuth {token}'}


def soft_request(address, token, type='get', verify=False, json=None, data=None, params={}, max_tries=15, verbose=True, status_whitelist=[201, 200], status_warn=[], raw_text=False):

    cooldown = 4
    headers = get_headers(token)

    # костыль, чтобы что-то принтилось, если реквест не пройдёт
    r = requests.Response()
    r._content = b'{"errors":"request not created!"}'

    tries = 1
    while True:
        try:
            with requests.Session() as session:
                if type == 'get':
                    r = session.get(address,
                                    params=params,
                                    verify=verify,
                                    headers=headers,
                                    json=json)
                elif type == 'post':
                    r = session.post(
                        address,
                        params=params,
                        verify=verify,
                        headers=headers,
                        json=json,
                        data=data
                    )
                elif type == 'patch':
                    r = session.patch(
                        address,
                        params=params,
                        verify=verify,
                        headers=headers,
                        json=json
                    )
                else:
                    raise TypeError('type must be equal "get", "patch" or "post"!')
            if r.status_code not in status_whitelist:
                str_statuses = map(str, status_whitelist)
                raise Exception(f'error not-{"/".join(str_statuses)} code')
            else:
                break
        except Exception as e:

            if verbose:
                print(e.__class__.__name__, e, sep=', ')  # тип ошибки и её комментарий

            if tries > max_tries:
                raise TimeoutError
            else:

                if verbose:
                    print(f'Connection error! Next try after {cooldown} seconds')
                    print(address)
                    print(r)
                    print(r.text)

                tries += 1
                time.sleep(cooldown)
                cooldown = min(2 * cooldown, 256)
                continue

    if raw_text:
        return r.text
    if r.status_code in status_warn:
        return {
            "error": "status_code in status_warn!",
            "status_code": r.status_code,
            "text_output": r.text
        }
    return r.json()
