from privacy_office.lib.soft_request.main import soft_request, staff_host


def is_dismissed(username, token):
    return soft_request(
        staff_host+'persons',
        token,
        params={
            '_fields': 'official',
            'login': username
        }
    )['result'][0]['official']['is_dismissed']


def is_robot(username, token):
    return soft_request(
        staff_host+'persons',
        token,
        params={
            '_fields': 'official',
            'login': username
        }
    )['result'][0]['official']['is_robot']


def is_has_chief(username, token):
    return soft_request(
        staff_host+'persons',
        token,
        params={
            '_fields': 'chief',
            'login': username
        }
    )['result'][0]['chief'] is not None


def get_chief(username, token):
    if not is_has_chief(username, token):
        raise Exception('chief is not exists!')
    if is_robot(username, token):
        raise Exception('robot!!!')

    return soft_request(
        staff_host+'persons',
        token,
        params={
            '_fields': 'chief',
            'login': username
        }
    )['result'][0]['chief']['login']


def tigran_number(username, token):
    if is_robot(username, token):
        raise Exception('robot!')
    # if is_dismissed(username, token):
    #     raise Exception('is dismissed!')

    return len(
        soft_request(
            staff_host+'persons',
            token,
            params={
                '_fields': 'chiefs',
                'login': username
            }
        )['result'][0]['chiefs']
    ) + 1


def get_nchief(n, username, token):
    assert n >= 0, "n must be an integer ≥0!"

    if n == 0:
        return username

    if not is_has_chief(username, token):
        raise Exception('chief is not exists!')
    if is_robot(username, token):
        raise Exception('robot!!!')

    return soft_request(
        staff_host+'persons',
        token,
        params={
            '_fields': 'chiefs',
            'login': username
        }
    )['result'][0]['chiefs'][n-1]['login']
