# %%
from privacy_office.lib.soft_request.main import soft_request, st_host, wiki_host
from privacy_office.lib.nirvana_combine.main import combine_this

import re
# import warnings
# warnings.filterwarnings("ignore")


# %%
def get_stats(token):
    query = 'issues?query=queue: qhide Status: closed Resolution: Решен'

    queues = {}
    meta = {
        'queues': 0,
        'tickets': 0
    }
    for n in range(1, 101):
        print(n)
        r = soft_request(
            st_host + query,
            token,
            params={
                'perPage': 100,
                'page': n
            },
            verify=False
        )
        if r == []:
            break

        for ticket in r:  # ticket - это issue со всеми параметрами
            if re.findall(
                'Приватные данные в очереди',
                ticket['summary']
            ):
                queue_name = ticket['summary'].split()[-1]
                reg_exp = f'{queue_name}' + r'-([\d]{1,9})'
                if re.findall(
                    reg_exp,
                    ticket['description']
                ):
                    indexes = re.findall(
                        reg_exp,
                        ticket['description']
                    )
                    m = max(
                        map(
                            int,
                            indexes
                        )
                    )
                    k = len(indexes)
                    prediction = m + m/k - 1
                    queues[queue_name] = prediction

    meta['queues'] = len(queues)
    meta['tickets'] = int(sum(queues.values()))
    return {'queues': queues, 'meta': meta}


# %%
def post_wiki(text, token):
    soft_request(wiki_host + 'privacy_office/qhide',
                 token,
                 type='post',
                 json={'body': text})

# %%

raw_text = '''
http://clubs.at.yandex-team.ru/mag/71249
**((https://wiki.yandex-team.ru/privacy_office/qhide/queue_hiding Основной гайд))**
QHide – проект по выявлению, нахождению и исправлению открытых очередей в Трекере с приватными данными.

За всё время QHide было закрыто
==очередей: {queues}==
с приватными данными, суммарно содержащих
==тикетов: {tickets:,}.==
'''


# %%
@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    stats = get_stats(token1)['meta']
    text = raw_text.format(
        queues=stats['queues'],
        tickets=stats['tickets']
    )

    post_wiki(text, token2)
