# %%
from privacy_office.lib.soft_request.main import soft_request, st_host, wiki_host
from privacy_office.lib.nirvana_combine.main import combine_this

from datetime import datetime


# %%
# Глава I — собираем qhide_report
def is_queue_valid(queue, token):
    return soft_request(
        st_host+f'queues/{queue}',
        token,
        status_whitelist=[201, 200, 403, 404]
    ).get('statusCode', 200) != 404


def get_query_len(query, token):
    return soft_request(
        st_host + 'issues/_count',
        token,
        params={
            'query' : query
        }
    )


def scrape_tickets(query, token):
    # считаю длину очереди — для ускорения обхода
    query_len = get_query_len(query, token)

    tickets = sum(
        [
            soft_request(
                st_host + 'issues',
                token,
                params={
                    'query' : query,
                    'perPage': 100,
                    'page': i
                }
            )
            # от страницы 1 до максимально возможной (но не больше 100)
            for i in range(1, 1 + min(100, 1 + ((query_len - 1) // 100)))
        ],
        # https://stackoverflow.com/a/716489
        []
    )

    return tickets


# %%
def get_queues_to_check(token):
    out = []
    for ticket in scrape_tickets('queue: qhide Tags: "нужно_ответить_(Privacy_Office)"', token):
        to_add = {}

        queue = ticket['summary'].split()[-1]
        to_add['queue'] = queue
        ticket_key = ticket['key']
        to_add['qhide_ticket_key'] = ticket_key

        if soft_request(
            st_host+f"queues/{to_add['queue']}",
            token,
            status_whitelist=[201, 200, 403, 404]
        ).get('statusCode', 200) == 404:
            to_add['queue_smth_wrong'] = f"\"{ticket['summary']}\"\nНевалидная очередь или плохое имя тикета"
        else:
            to_add['queue_smth_wrong'] = None

        out.append(to_add)

    return out


# %%
def scrape_components(tickets_to_watch):
    components_report = {
        "components": None,
        "non_components": None
    }
    components = {}
    non_components = {}
    for ticket in tickets_to_watch:
        if 'components' in ticket:
            for component in ticket['components']:
                components.setdefault(
                    component['id'],
                    {
                        'display': component['display'],
                        'tickets_cnt': 0,
                        'example': ticket['key']
                    }
                )
                components[component['id']]['tickets_cnt'] += 1
        else:
            non_components.setdefault("display", "🙅🏻‍♀️без компонент")
            non_components.setdefault("tickets_cnt", 0)
            non_components.setdefault("example", ticket['key'])
            non_components['tickets_cnt'] += 1

    if components:
        components_report["components"] = components
    if non_components:
        components_report["non_components"] = non_components
    return components_report


# %%
def get_my_username(token):
    return soft_request(
        st_host+'myself',
        token,
    )['login']


def check_open_but_closed_tickets(user_report, token):
    smth_wrong = None

    tickets_to_check = []
    if user_report['components']:
        tickets_to_check += [user_report['components'][component_id]['example'] for component_id in user_report['components']]
    if user_report['non_components']:
        tickets_to_check.append(user_report['non_components']['example'])

    for ticket in tickets_to_check:
        if soft_request(
            st_host+f'issues/{ticket}',
            token,
            status_whitelist=[201, 200, 403]
        ).get('statusCode', 200) == 403:
            smth_wrong = '!!Баг Трекера!!, посмотреть ручками! ((https://st.yandex-team.ru/STARTREK-24038 STARTREK-24038)) '\
                f'\nТикет {ticket} закрыт, но виден по query-запросу ({get_my_username(token)}@)'
            break
    return smth_wrong


# %%
def get_queue_report_user(queue, token):
    user_report = {
        "tickets_seen": get_query_len(f'queue: {queue.lower()} Assignee: !me() Followers: !me() Author: !me() Access: !me()', token),
        "components": None,
        "non_components": None,
        "smth_wrong": None
    }

    tickets_to_watch = scrape_tickets(f'queue: {queue.lower()} Assignee: !me() Followers: !me() Author: !me() Access: !me()', token)
    user_report.update(scrape_components(tickets_to_watch))
    user_report["smth_wrong"] = check_open_but_closed_tickets(user_report, token)

    return user_report


# %%
def get_queue_report(queue, token_human, token_robot):
    return {
        "human": get_queue_report_user(queue, token_human),
        "robot": get_queue_report_user(queue, token_robot)
    }


# %%
def get_qhide_report(token_human, token_robot):
    qhide_report = get_queues_to_check(token_robot)

    for qhide_report_row in qhide_report:
        if qhide_report_row['queue_smth_wrong']:
            qhide_report_row['queue_check'] = None
        else:
            queue = qhide_report_row['queue']
            qhide_report_row['queue_check'] = get_queue_report(queue, token_human, token_robot)

    return qhide_report


# %%
# Глава II — превращаем qhide_report в вики-страницу
def get_components_report_text(components, non_components, spoiler_name):
    text = '<{' + f'{spoiler_name}\n'
    text += 'кол-во тикетов | имя (id) | пример\n'
    if components:
        for id in {k: v for k, v in sorted(components.items(), key=lambda item: item[1]['tickets_cnt'], reverse=True)}:
            text += f"{components[id]['tickets_cnt']} — {components[id]['display']} ({id}) ((https://st.yandex-team.ru/{components[id]['example']} {components[id]['example']}))\n"
    if non_components:
        text += f"{non_components['tickets_cnt']}  — {non_components['display']} ((https://st.yandex-team.ru/{non_components['example']} {non_components['example']}))\n"
    text += '}>'
    return text


# %%
def queue_check_to_text(queue_check):
    out = {}
    for key in queue_check:
        queue_check_user = queue_check[key]
        tickets_seen = queue_check_user['tickets_seen']
        if tickets_seen == 0:
            out[key] = '✅ 0 ✅'
            continue

        components = queue_check_user['components']
        non_components = non_components = queue_check_user['non_components']
        text = get_components_report_text(components, non_components, f"❌ {tickets_seen} ❌")
        out[key] = text
    return out


# %%
def queue_check_to_assignee_comment(queue_check):
    human_check = queue_check['human']
    robot_check = queue_check['robot']
    human_see = human_check['tickets_seen']
    robot_see = robot_check['tickets_seen']
    if human_see == robot_see == 0:
        out = 'Вижу, что всё скрыто. Закрываю тикет. Вы восхитительны!'
    else:

        out = f"Привет!\nЯ посмотрел сколько тикетов видят человек и робот.\nЧеловек: {human_see}.\nРобот: {robot_see}.\n"
        if human_see == 0 and robot_see != 0:
            out += '* Вижу, что робот видит тикеты, а человек — нет. Вероятно, дело в группе '\
                '((https://wiki.yandex-team.ru/privacy_office/qhide/queuehiding/#top-1prichinanepravilnyxnastroekgruppyyandex.botsijandeks yandex.bots)). '\
                'Посмотри на эту группу в настройках очереди, и если она есть, убери у неё права на чтение и редактирование. Если же такой группы нигде '\
                'нет — покажи скриншотом как выглядит таблица с доступами — будем разбираться.\n'
        elif human_see != 0 and robot_see == 0:
            out += '* Вижу, что робот не видит тикеты, а человек — видит. Вероятно, дело в группе '\
                '((https://wiki.yandex-team.ru/privacy_office/qhide/queuehiding/#top-1prichinanepravilnyxnastroekgruppyyandex.botsijandeks Яндекс)), '\
                'или в какой-нибудь другой группе, в которую я могу входить. Посмотри, есть ли такие группы в настройках очереди, и если они есть, '\
                'убери у них права на чтение и редактирование, не забыв выдать своей команде нужные доступы (чтобы ничего не отвалилось). Если с '\
                'группами нет никаких идей — покажи скриншотом как выглядит таблица с доступами — будем разбираться.\n'

        # человек или робот видит только тикеты с компонентами
        if (not human_check['non_components'] and human_see) or (not robot_check['non_components'] and robot_see):
            to_add = 'Вероятно, в некоторых компонентах есть дополнительные разрешения, на которые тоже стоит посмотреть '\
                '((https://wiki.yandex-team.ru/privacy_office/qhide/queuehiding/#2.nastrojjkivkomponentax (на-что-нажимать) )).\n'
            out += '* Вижу, что '
            # и человек, и робот
            if (not human_check['non_components'] and human_see) and (not robot_check['non_components'] and robot_see):
                out += 'и человек, и робот видят тикеты, но все они с компонентами. '
                out += to_add
                out += f"{get_components_report_text(human_check['components'], None, 'Вот какие компоненты я вижу с человека:')}\n"
                out += f"{get_components_report_text(robot_check['components'], None, 'Вот какие компоненты я вижу с робота:')}\n"
            # только робот
            elif (human_check['non_components'] or not human_see) and (not robot_check['non_components'] and robot_see):
                out += 'хоть робот и видит некоторые тикеты, все они с компонентами. '
                out += to_add
                out += f"{get_components_report_text(robot_check['components'], None, 'Вот какие компоненты я вижу с робота:')}\n"
            # только человек
            elif (not human_check['non_components'] and human_see) and (robot_check['non_components'] or not robot_see):
                out += 'хоть человек и видит некоторые тикеты, все они с компонентами. '
                out += to_add
                out += f"{get_components_report_text(human_check['components'], None, 'Вот какие компоненты я вижу с человека:')}\n"

        if human_see != 0 and robot_see != 0 and not((not human_check['non_components'] and human_see) or (not robot_check['non_components'] and robot_see)):
            out += 'Прошу проверить настройки очереди на наличие групп типа '\
                '((https://wiki.yandex-team.ru/privacy_office/qhide/queuehiding/#top-1prichinanepravilnyxnastroekgruppyyandex.botsijandeks Яндекс и yandex.bots)).'
    return '<{Комментарий в тикет (клик по тексту чтобы скопировать)\n%%' + out + '%%}>'


# %%
def get_wiki_table_row(qhide_report_row):
    queue_text = None
    human_text = None
    robot_text = None
    smth_wrong_text = None
    explanation_text = None

    queue = qhide_report_row['queue']
    qhide_ticket_key = qhide_report_row['qhide_ticket_key']
    queue_text = f"{queue}\n((https://st.yandex-team.ru/{qhide_ticket_key} {qhide_ticket_key}))"

    if qhide_report_row['queue_smth_wrong']:
        human_text = '¯\\\\_(ツ)_/¯'
        robot_text = '¯\\\\_(ツ)_/¯'
        smth_wrong_text = "❗️❗️❗️"
        explanation_text = qhide_report_row['queue_smth_wrong']
    else:
        queue_check = qhide_report_row['queue_check']
        queue_check_text = queue_check_to_text(queue_check)
        human_text = queue_check_text['human']
        robot_text = queue_check_text['robot']

        if queue_check['human']['smth_wrong']:
            smth_wrong_text = '❗️❗️❗️'
            explanation_text = queue_check['human']['smth_wrong']
        elif queue_check['robot']['smth_wrong']:
            smth_wrong_text = '❗️❗️❗️'
            explanation_text = queue_check['robot']['smth_wrong']
        else:
            smth_wrong_text = r'\-\-\-'
            explanation_text = queue_check_to_assignee_comment(queue_check)

    return [
        queue_text,
        human_text,
        robot_text,
        smth_wrong_text,
        explanation_text
    ]


# %%
def make_wiki_table(table_rows):
    # return '#|\n' + ''.join(
    #     [
    #         f"""|| {'| '.join([
    #             str(obj) for obj in row
    #         ])}||\n""" for row in rows
    #     ]
    # ) + '|#'

    # Иногда, сигара — это просто сигара

    out = '#|\n'
    for row in table_rows:
        out += '|| ' + '| '.join([str(obj) for obj in row]) + '||\n'
    out += '|#'
    return out


# %%
def generate_wiki_table(qhide_report):
    table_rows = [['Очередь', 'Человек', 'Робот', '¯\\\\_(ツ)_/¯', 'Пояснение']]
    table_rows += [get_wiki_table_row(qhide_report_row) for qhide_report_row in qhide_report]

    return make_wiki_table(table_rows)


# %%
def post_wiki(text, token):
    soft_request(wiki_host + 'privacy_office/private/duty/qhide/dutyhelper',
                 token,
                 type='post',
                 json={'body': text})


# %%
@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    token_human = token1
    token_robot = token2

    qhide_report = get_qhide_report(token_human, token_robot)

    wiki_text = f"Проверка проведена {datetime.now().strftime('%Y-%m-%d %H:%M:%S')} дежурным {get_my_username(token_human)}@.\n{generate_wiki_table(qhide_report)}"

    post_wiki(wiki_text, token_robot)

    return {
        "out1": qhide_report
    }
