# %%
from privacy_office.lib.soft_request.main import soft_request, st_host, abc_host, staff_gap_host
from privacy_office.lib.nirvana_combine.main import combine_this
from privacy_office.lib.staff_tree.main import is_robot, is_has_chief, tigran_number, get_nchief
from datetime import datetime, timedelta


# %%
def create_comment(token, key, text=None, summon=None, create_tag=False):
    if type(summon) != str:
        summon = list(set(summon))  # API трекера требует, чтобы список был без повторений
    soft_request(
        st_host+f'issues/{key}/comments',
        token,
        type='post',
        json={
            "text": text,
            "summonees" : summon
        }
    )

    if create_tag:
        soft_request(
            st_host+f'issues/{key}',
            token,
            type='patch',
            json={
                "tags": {
                    "add": [
                        "нужно_ответить_(Privacy_Office)"
                    ]
                }
            }
        )


# %%
def get_duty(token):
    today = datetime.now().strftime('%Y-%m-%d')
    # смотрю на такой большой отрезок, чтобы даже в случае длинных нерабочих отрезков множество было непусто
    next_month = (datetime.now() + timedelta(days=30)).strftime('%Y-%m-%d')
    return soft_request(
        abc_host + f"duty/shifts/?service__slug=privacy_office&date_from={today}&date_to={next_month}",
        token
    )['results'][0]['person']['login']


# %%
def escalate_watch_dog(token):
    qhide_duty = get_duty(token)

    for n in range(100):
        r = soft_request(
            st_host+'issues',
            token,
            params={
                'query': 'queue: QHIDE Status: !closed Deadline: <= today() Updated: <= today()-4d',
                'perPage': 100,
                'page': n+1
            }
        )
        if r == []:
            break

        for ticket in r:
            key = ticket['key']

            # нет исполнителя
            if 'assignee' not in ticket:
                print('🔥No assignee!')
                create_comment(
                    token,
                    key,
                    text=f"Привет, {qhide_duty}@!\n У этого тикета нет исполнителя. Определи, пожалуйста, исполнителя и призови его сюда.",
                    summon=qhide_duty,
                    create_tag=True
                )
                continue

            assignee_name = ticket['assignee']['id']
            print(key, assignee_name)

            # исполнитель есть, но в отпуске\командировке
            if not soft_request(
                staff_gap_host+'availability',
                token,
                params={
                    'l': assignee_name
                }
            )['persons'][assignee_name]['available_now']:
                print(f'{assignee_name} is not available! Skipped!')
                continue

            escalate_level = ((datetime.now() - datetime.strptime(ticket['deadline'], '%Y-%m-%d')).days + 7) // 7
            ticket.setdefault('iterationCount', 0)
            iterationCount = ticket['iterationCount']
            print(f'{escalate_level} >= {iterationCount}, {escalate_level >= iterationCount}')
            print(f'iterationCount = {iterationCount}')

            # мы уже достигли нужного уровня эскалации
            if escalate_level < iterationCount:
                continue

            # робот
            if is_robot(assignee_name, token):
                print('🔥Robot!')
                create_comment(
                    token,
                    key,
                    text=f"Привет, {qhide_duty}@!\n Ответственный за эту очередь робот, и это очень нехорошо. "
                        "Определи, пожалуйста, ответственного за него и призови его сюда.",
                    summon=qhide_duty,
                    create_tag=True
                )
                continue

            # без начальника
            if not is_has_chief(assignee_name, token):
                print('🔥Has not chief!')
                create_comment(
                    token,
                    key,
                    text=f"Привет, {qhide_duty}@!\n У ответственного за эту очередь нет руководителя, и это очень нехорошо. "
                        "Вероятно, это заброшенная очередь у заброшенного отдела. "
                        "Определи, пожалуйста, что это так, и если очередь действительно заборошена, напиши об этом в TOOLSUP.",
                    summon=qhide_duty,
                    create_tag=True
                )
                continue

            max_escalate_level = tigran_number(assignee_name, token) - 2
            if escalate_level >= max_escalate_level + 2:
                print('🔥Abandonded!')
                create_comment(
                    token,
                    key,
                    text=f"Привет, {qhide_duty}@!\n Видимо, призывы здесь не работают. Напиши исполнителю куда-нибудь и лично позови его сюда.",
                    summon=qhide_duty,
                    create_tag=True
                )
                continue

            if escalate_level >= max_escalate_level:
                # эскалируем максимально возможного
                to_summon = get_nchief(max_escalate_level, assignee_name, token)
            else:
                # эскалируем на нужный уровень
                to_summon = get_nchief(iterationCount, assignee_name, token)
            create_comment(
                token,
                key,
                text=f"Привет!\n Я заметил, что эта задача выполняется слишком долго, пожалуйста, займитесь решением проблемы.\n Призываю {to_summon}",
                summon=(assignee_name, to_summon)
            )
            soft_request(
                st_host+f'issues/{key}',
                token,
                type='patch',
                json={
                    "iterationCount": iterationCount + 1
                }
            )


# %%
@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    escalate_watch_dog(token1)
