# %%
import warnings
from privacy_office.lib.soft_request.main import soft_request, st_host
from privacy_office.lib.give_achievment.main import give_achievment
from privacy_office.lib.nirvana_combine.main import combine_this
warnings.filterwarnings("ignore")


# %%
def get_stats(token):

    assignees = {}
    for n in range(1, 101):
        r = soft_request(
            st_host + 'issues?query=Queue: qhide Status: closed Resolution: Решен',
            token,
            params={
                'perPage': 100,
                'page': n
            },
            verify=False
        )
        if r == []:
            break

        for ticket in r:  # ticket - это issue со всеми параметрами
            if 'assignee' not in ticket:
                continue
            assignee_username = ticket['assignee']['id']
            assignees[assignee_username] = assignees.get(assignee_username, 0) + 1

    out = []
    for username in [assignee_username for assignee_username, freq in assignees.items() if freq >= 3]:
        out.append(username)
    return out


# %%
@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    qhide_achievment_id = 3826

    stats = get_stats(token1)
    print(stats)

    for username in stats:
        give_achievment(username, qhide_achievment_id, token2, verbose=True)
