# %%
from privacy_office.lib.soft_request.main import soft_request, st_host, staff_host, abc_host
from privacy_office.lib.staff_tree.main import tigran_number
from privacy_office.lib.nirvana_combine.main import combine_this
from datetime import datetime, timedelta, timezone
# для выбора случайных примеров плохих тикетов
import random


# %%
def get_duty(token):
    today = datetime.now().strftime('%Y-%m-%d')
    # смотрю на такой большой отрезок, чтобы даже в случае длинных нерабочих отрезков множество было непусто
    next_month = (datetime.now() + timedelta(days=30)).strftime('%Y-%m-%d')
    return soft_request(
        abc_host + f"duty/shifts/?service__slug=privacy_office&date_from={today}&date_to={next_month}",
        token
    )['results'][0]['person']['login']


# %%
def relevant_assignee(username, token):
    if tigran_number(username, token) <= 1:
        return False
    return soft_request(
        'https://staff.yandex-team.ru/gap-api/api/availability',
        token,
        params={
            'l': username,
            'date_from': (datetime.now() + timedelta(days=2)).strftime('%Y-%m-%d'),
            'date_to': (datetime.now() + timedelta(days=32)).strftime('%Y-%m-%d')
        }
    )['persons'][username]['availability'] != []


# %%
def get_responsible(abc, token, verbose=True):
    print(f'abc = {abc}')
    # 35 - продакт менеджер
    r = soft_request(abc_host+f'services/members?service__slug={abc}&role=35&is_robot=false', token)['results']
    # Здесь и далее — отсекаем ребят с числом Тиграна <= 1
    products = [result['person']['login'] for result in r]
    products_relevant = [login for login in products if relevant_assignee(login, token)]
    if verbose:
        print('products =', products, products_relevant)
    if products_relevant != []:
        return products_relevant[0]

    # 2 - проджект менеджер
    r = soft_request(abc_host+f'services/members?service__slug={abc}&role=2&is_robot=false', token)['results']
    projects = [result['person']['login'] for result in r]
    projects_relevant = [login for login in projects if relevant_assignee(login, token)]
    if verbose:
        print('projects =', projects, projects_relevant)
    if projects_relevant != []:
        return projects_relevant[0]

    # 3 - самый главный
    r = soft_request(abc_host+f'services/members?service__slug={abc}&role=1&is_robot=false', token)['results']
    heads = [result['person']['login'] for result in r]
    heads_relevant = [login for login in heads if relevant_assignee(login, token)]
    if verbose:
        print('heads =', heads, heads_relevant)
    if heads_relevant != []:
        return heads_relevant[0]

    # если совсем плохо — кто угодно
    r = soft_request(abc_host+f'services/members?service__slug={abc}&is_robot=false', token)['results']
    someones = [result['person']['login'] for result in r]
    someones_relevant = [login for login in someones if relevant_assignee(login, token)]
    if verbose:
        print('someones =', someones, someones_relevant)
    if someones_relevant != []:
        return someones_relevant[0]
    raise Exception(f'No candidates! abc = {abc}')


# %%
def get_staff_name(username, token):
    return soft_request(
        staff_host + 'persons',
        token,
        params={
            '_pretty': 1,
            'login': username
        },
        verify=False
    )['result'][0]['name']['first']['ru']

# %%
raw_description = '''Привет, ((кто:{responsible_username} {responsible_name}))!

Согласно ((https://clubs.at.yandex-team.ru/mag/59764 политике размещения внешних скриптов на страницах Яндекса)), в целях обеспечения конкурентной безопасности нашей аудитории, внешние скрипты'''\
'''в рамках Яндексовых доменов должны быть или захощены внутри, или сняты с наших ресурсов. Исключения давайте обсуждать в индивидуальном порядке.

=====Правила и возможные решения проблемы можно прочитать в этом **((https://wiki.yandex-team.ru/privacy_office/scriptcut/policy/ гайде))**.=====

По результатам аудита ресурсов Яндекса на наличие установленных внешних скриптов, кажется, что на URL **{common_URL}** присутствуют внешние JS-скрипты.

{problems}


Предположительно, за URL адрес **{common_URL}** отвечает ABC-сервис https://abc.yandex-team.ru/services/{abc}.
**Если я попал не по адресу**, просьба перевесить задачу на ответственного человека.

Спасибо большое за оперативное внимание к данной проблеме!

++!!(сер)**Примечание**: это полуавтоматический тикет, основанный на результатах проверки, выполненной ботом. Некоторая (или вся) фактическая информация, приведенная в этом тикете, может оказаться'''\
'''неправдивой. В таком случае просьба понять, простить и ответить, чтобы исправить эту оплошность!!++
'''


# %%
def get_incidents(main_table, incident_table, token, today_limit=1, verbose=True):
    existed_common_URLs = [row['common_URL'] for row in main_table]

    def get_index(common_URL):
        return existed_common_URLs.index(common_URL)

    def get_issue_key(common_URL):
        return main_table[get_index(common_URL)]['issue_key']

    incidents = [incident for incident in incident_table if incident['abc_whitelist'] is not True]

    old_incidents = [incident for incident in incidents if incident['common_URL'] in existed_common_URLs]
    old_incidents = [
        {
            'body': incident,
            'main_table_index': get_index(incident["common_URL"])
        }
        for incident in old_incidents
        if
        datetime.now(tz=timezone.utc) -
        datetime.strptime(
            soft_request(
                st_host + f'issues/{get_issue_key(incident["common_URL"])}',
                token
            )['updatedAt'],
            '%Y-%m-%dT%H:%M:%S.%f%z'
        ) >= timedelta(days=10)
        and
        soft_request(
            st_host + f'issues/{get_issue_key(incident["common_URL"])}',
            token
        )['status']['key'] == 'closed'
    ]

    new_incidents = [
        {
            'body': incident,
            'main_table_index': None
        }
        for incident in incidents
        if incident['common_URL'] not in existed_common_URLs
    ]

    common_incidents = old_incidents + new_incidents
    if verbose:
        print(f'total incidents: {len(common_incidents)}')

    if len(common_incidents) <= today_limit:
        return common_incidents
    else:
        return random.sample(common_incidents, today_limit)


# %%
def get_examples_URL(examples):
    example_non_ads = [example['example_non_ad'] for example in examples if example['example_non_ad'] is not None]
    example_ads = [example['example_ad'] for example in examples if example['example_ad'] is not None]
    return {'non_ad': example_non_ads, 'ad': example_ads}


# %%
def get_script_problem_lines(scripts):
    to_add = ''
    only_ad_exists = False
    for script in scripts:
        examples_URL = get_examples_URL(script['examples'])
        postfix = ''
        if examples_URL['non_ad'] == []:
            postfix = '++!!*!!++'
            only_ad_exists = True

        all_examples = [example.replace(' ', '%20') for example in (examples_URL['non_ad'] + examples_URL['ad'])]
        examples_numerated = ' '.join([f"(({all_examples[:5][i]} [{i+1}]))" for i in range(len(all_examples[:5]))])

        to_add += f"* **{script['script_URL']}**: {examples_numerated} {postfix}\n"

    return {'to_add': to_add, 'only_ad_exists': only_ad_exists}


# %%
def get_problems_text(scripts, verbose):
    scripts_small = [script for script in scripts if script['problem_type'] == 'small']
    scripts_big = [script for script in scripts if script['problem_type'] == 'big']

    if verbose:
        print(f'small - {len(scripts_small)}, big - {len(scripts_big)}')

    problems = ''

    only_ad_exists_small, only_ad_exists_big = False, False
    if scripts_small != []:
        problems += "\n======Скрипты, встречающиеся на большом количестве URL'ов:======\n"
        lines = get_script_problem_lines(scripts_small)
        problems += lines['to_add']
        only_ad_exists_small = lines['only_ad_exists']

    if scripts_big != []:
        problems += "\n======Скрипты, встречающиеся на небольшом количестве URL'ов с большим трафиком:======\n"
        lines = get_script_problem_lines(scripts_big)
        problems += lines['to_add']
        only_ad_exists_big = lines['only_ad_exists']

    if only_ad_exists_small or only_ad_exists_big:
        if verbose:
            print('❗️[!] есть скрипты только на рекламных урлах!')
        problems += '++!!*!! все найденные примеры находятся на страницах с долей рекламного трафика >70%. Для таких страниц существуют'\
            '((https://wiki.yandex-team.ru/privacy_office/scriptcut/policy/#skriptyreklamnyxsistemdljaboleekachestvennogotargetinganaprimergoogleanalytics дополнительные разрешения)).++ \n'

    return problems


# %%
def ticket_creator(main_table, incident_table, token, today_limit=1, verbose=True):
    qhide_duty = get_duty(token)

    for incident in get_incidents(main_table, incident_table, token, today_limit=today_limit, verbose=verbose):
        body = incident['body']
        main_table_index = incident['main_table_index']
        if main_table_index is not None:
            old_issue_key = main_table[incident["main_table_index"]]["issue_key"]

        common_URL = body['common_URL']
        print(common_URL)
        abc = body['abc']
        assignee_username = get_responsible(abc, token, verbose=verbose)
        assignee_name = get_staff_name(assignee_username, token)
        if verbose:
            print(f'{common_URL}, assignee - {assignee_username} {assignee_name}')
            if main_table_index is not None:
                print(f'❗️❗️❗️[!!!] re-warning common_URL: {old_issue_key}')

        summary = f'Внешние скрипты - {common_URL}'

        description = raw_description.format(
            abc=abc,
            common_URL=common_URL,
            problems=get_problems_text(scripts=body['scripts'], verbose=verbose),
            responsible_username=assignee_username,
            responsible_name=assignee_name,
        )

        # создание тикета
        query = 'issues/'
        r = soft_request(
            st_host + query,
            token,
            verify=False,
            json={
                "queue": 'SCRIPTCUT',
                "type": 'incident',
                "summary": summary,
                "description": description,
                "assignee": assignee_username,
                "access": qhide_duty,
                "priority": 'critical',
                "iterationCount": 0,
            },
            type='post'
        )
        new_issue_key = r['key']

        if verbose:
            print(new_issue_key)

        # линк к старому тикету, если повтор
        if main_table_index is not None:
            query = f'issues/{new_issue_key}/links'
            soft_request(
                st_host + query,
                token,
                verify=False,
                json={
                    "relationship": 'duplicates',
                    "issue": old_issue_key
                },
                type='post'
            )

        script_URLs = {
            script['script_URL']: sum(
                [script_example['script_traffic']for script_example in script['examples']]
            )
            for script in body['scripts']
        }

        to_main_table = {
            "common_URL": common_URL,
            "abc": abc,
            "last_checked": datetime.now().strftime('%Y-%m-%d'),
            "issue_key": new_issue_key,
            "script_URLs": script_URLs,
            "scripts": body['scripts']
        }

        if main_table_index is not None:
            main_table[main_table_index] = to_main_table
        else:
            main_table.append(to_main_table)

    return main_table


# %%
@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    today_limit = 1
    return {
        "out1": ticket_creator(in1, in2, token1, today_limit=today_limit, verbose=True)
    }
