# %%
# https://github.com/SeleniumHQ/selenium/issues/8672
import json
def send(driver, cmd, params={}):
    resource = "/session/%s/chromium/send_command_and_get_result" % driver.session_id
    url = driver.command_executor._url + resource
    body = json.dumps({'cmd': cmd, 'params': params})
    response = driver.command_executor._request('POST', url, body)
    return response.get('value')

# %%
def get_logs(url_list):
    import selenium.webdriver
    
    options = selenium.webdriver.ChromeOptions()
    options._caps = {
        "browserName": "chrome",
        "version": "21.8.0.1968",
        "pageLoadStrategy": "normal", #none #normal #eager
        "goog:loggingPrefs": {
            "performance": "ALL"
        }
    }

    remote_connection = selenium.webdriver.remote.remote_connection.RemoteConnection(
        'http://privacy-office@sw.yandex-team.ru:80/v0',
        # временный костыль, можно убрать, когда тикет 
        # https://st.yandex-team.ru/FEI-24731 закроют
        resolve_ip=False
    )
    remote_connection.set_timeout(150) #seconds

    logs_dict = {}
    errors_list = []

    i = 0
    for url in url_list:
        print(i)
        try:
            driver = selenium.webdriver.Remote(
                command_executor=remote_connection,
                options=options
            )

            # print(url)
            # driver.implicitly_wait(10)
            driver.set_page_load_timeout(40)
            # user_agent = driver.execute_script("return navigator.userAgent;")
            # print(user_agent)
            
            driver.get(url)

            logs_dict[url] = {'performance_log': []}
            
            logs_dict[url].update(
                send(
                    driver,
                    'Page.getFrameTree',
                    {}
                )
            )

            logs_dict[url]['performance_log'] = (
                driver.execute(
                    'getLog',
                    {
                        'type': 'performance'
                    }
                )['value']
            )


            # print(f"url={url}")

            # is_bug = False
        except selenium.common.exceptions.TimeoutException:
            errors_list.append(url)

        #     # Иногда селениум никогда не догружает страницу до конца, вне зависимости
        #     # от времени таймаута. Например, dostavka.yandex.ru фризится всегда,
        #     # некоторые домены — делают это с какой-то вероятностью. Пока опыт показывает,
        #     # что всё подгружается до какого-то момента, и там уже есть достаточно материала.
        #     print(f"Timeout! url={url}")

        #     # tmp
        #     is_bug = True
        #     # tmp
        finally:

            # # tmp
            # a = send(
            #         driver,
            #         'Page.getFrameTree',
            #         {}
            #     )
            # if is_bug:
            #     print('is bug')
            #     print(a)
            # # tmp
            driver.quit()
        i += 1

    return logs_dict, errors_list

# %%
import tld
def get_domain(url):
    out = tld.get_fld(url, fail_silently=True)
    if out == None:
        out = ''
    return out

# %%
def old_get_frame_url_map(frameTree):
    # Получает расшифровки фреймов через Page.getFrameTree
    frame_to_url = {}

    frame_to_url[frameTree['frame']['id']] = get_domain(frameTree['frame']['securityOrigin'])
    if 'childFrames' in frameTree:
        for childFrame in frameTree['childFrames']:
            frame_to_url.update(old_get_frame_url_map(childFrame))
    return frame_to_url

# %%
def new_get_frame_url_map(performance_log):
    # Получает расшифровки фреймов напрямую из Performance-лога
    messages = [json.loads(obj['message'])['message'] for obj in performance_log]
    frames = [message['params']['frame'] for message in messages if message['method'] == 'Page.frameNavigated']
    frame_to_url = dict(
        [
            (
                frame['id'],
                get_domain(frame['securityOrigin'])
            )
            for frame in frames
        ]
    )
    
    return frame_to_url

# %%
def logs_to_report(logs_dict, ya_domains, ya_non_cookie_domains):
    # Костыль, чтобы фреймы без владельца (превращаются в '' после всех обрезаний) причислялись к Яндексовым безкуковым
    ya_non_cookie_domains_plus = ya_non_cookie_domains + ['']

    request_report = {}
    
    for url in logs_dict:
        performance_log = logs_dict[url]['performance_log']
        frameTree = logs_dict[url]['frameTree']
        
        # Я не знаю почему, но ни 'старый', ни 'новый' способы не дают полную картину. Это два множества с непустыми пересечениями и двумя непустыми разностями.
        # Объединение двух словарей работает. Как это работает — 🤷🏻‍♀️
        frame_url_map = old_get_frame_url_map(frameTree)
        frame_url_map.update(new_get_frame_url_map(performance_log))

        request_report.setdefault(url, {'yandex_cookie': {}, 'yandex_non_cookie': {}, 'not_yandex': {}})

        logs_messages = [json.loads(log['message'])['message'] for log in performance_log]

        for params in [message['params'] for message in logs_messages if message['method']=='Network.requestWillBeSent']:
            request_url = get_domain(params['request']['url'])
            request_type = params['type'] # 'Font', 'Stylesheet', 'Script', 'Image', 'Other', 'XHR'

            if params['frameId'] not in frame_url_map:
                print('!')
                print(url)

            request_frame = frame_url_map[params['frameId']]

            if request_frame in ya_non_cookie_domains_plus:
                frame_type = 'yandex_non_cookie'
            elif request_frame in ya_domains:
                frame_type = 'yandex_cookie'
            else:
                frame_type = 'not_yandex'
            dict_frame_type = request_report[url][frame_type]

            dict_frame_type.setdefault(request_frame, {})
            dict_request_frame = dict_frame_type[request_frame]

            dict_request_frame.setdefault(request_url, list())
            dict_request_url = dict_request_frame[request_url]

            # print(request_type)
            if request_type not in dict_request_url:
                dict_request_url.append(request_type)
    
    return request_report

# %%
def clean_report(request_report, ya_domains):
    ya_domains_plus = ya_domains + ['']
    import copy
    report = copy.deepcopy(request_report)
    for url in report:
        report_url = report[url]
        for type in report_url:
            report_type = report_url[type]
            for iframe in report_type:
                report_type[iframe] = {key:report_type[iframe][key] for key in report_type[iframe] if key not in ya_domains_plus}
    
    return report

# %%
def main(ya_domains, ya_non_cookie_domains):
    tmp_1 = get_logs(['https://market.yandex.ru'])
    tmp_2 = logs_to_report(tmp_1[0], ya_domains, ya_non_cookie_domains)
    tmp_3 = clean_report(tmp_2, ya_domains)

    return tmp_3