# %%
import warnings
from privacy_office.lib.soft_request.main import soft_request, st_host
from privacy_office.lib.give_achievment.main import give_achievment
from privacy_office.lib.nirvana_combine.main import combine_this
warnings.filterwarnings("ignore")


# %%
def get_stats(token):

    assignees = []
    for n in range(1, 101):
        r = soft_request(
            st_host + 'issues?query=Queue: scriptcut Status: closed Resolution: Решен',
            token,
            params={
                'perPage': 100,
                'page': n
            },
            verify=False
        )
        if r == []:
            break

        for ticket in r:  # ticket - это issue со всеми параметрами
            if 'assignee' not in ticket:
                continue
            assignee_username = ticket['assignee']['id']
            assignees.append(assignee_username)

    out = assignees
    return out


# %%
@combine_this
def main(in1, in2, in3, token1, token2, token3, param1, param2, param3):
    scriptcut_achievment_id = 4790

    stats = get_stats(token1)
    print(stats)

    for username in stats:
        give_achievment(username, scriptcut_achievment_id, token2, verbose=True)
