USE hahn;
PRAGMA yt.InferSchema = '1';

$date_start = '2022-05-02';
$date_end   = '2022-05-08';
--$source = '//home/goods_quality/topilskiy-ak/catfilter/showlog/prime/daily';
$query_counts = '//home/goods_quality/topilskiy-ak/catfilter/collect_gzt/basket/backup/2022-05-02_2022-05-08';
$classifier_source_dir = '//home/goods_quality/topilskiy-ak/catfilter/showlog/prime_legacy/daily_wpharma';

$output = '//home/goods_quality/topilskiy-ak/catfilter/collect_gzt/basket/' || $date_start || '_' || $date_end;

$query_classifiers = (
select
  query,
  max(cast(wizdetection_ecom_classifier_prob as double))          as wizdetection_ecom_classifier_prob,
  max(cast(wizdetection_cehac_ecom_classifier_prob as double))    as wizdetection_cehac_ecom_classifier_prob,
  max(cast(wizdetection_fashion_ecom_classifier_prob as double))  as wizdetection_fashion_ecom_classifier_prob,
  max(cast(wizdetection_home_ecom_classifier_prob as double))     as wizdetection_home_ecom_classifier_prob,
  max(cast(wizdetection_diy_ecom_classifier_prob as double))      as wizdetection_diy_ecom_classifier_prob,
  max(cast(wizdetection_pharma_ecom_classifier_prob as double))   as wizdetection_pharma_ecom_classifier_prob,
  max(cast(query_about_one_product as double))                    as query_about_one_product,
  max(cast(query_about_many_products as double))                  as query_about_many_products,
from range($classifier_source_dir, $date_start, $date_end)
group by query
);

insert into $output with truncate
select
  counts.*,
  wizdetection_ecom_classifier_prob ?? 0 as wizdetection_ecom_classifier_prob,
  wizdetection_cehac_ecom_classifier_prob ?? 0 as wizdetection_cehac_ecom_classifier_prob,
  wizdetection_fashion_ecom_classifier_prob ?? 0 as wizdetection_fashion_ecom_classifier_prob,
  wizdetection_home_ecom_classifier_prob ?? 0 as wizdetection_home_ecom_classifier_prob,
  wizdetection_diy_ecom_classifier_prob ?? 0 as wizdetection_diy_ecom_classifier_prob,
  wizdetection_pharma_ecom_classifier_prob ?? 0 as wizdetection_pharma_ecom_classifier_prob,
  query_about_one_product ?? 0 as query_about_one_product,
  query_about_many_products ?? 0 as query_about_many_products,
from
$query_counts as counts
left join
$query_classifiers as classifiers
on counts.query == classifiers.query
order by cnt desc
;
