import json
import collections
import libra
import baobab
from baobab import common as bcb
import tamus


class Row:
    def __init__(self, **kwargs):
        for (key, value) in kwargs.items():
            setattr(self, key, value)


################################################################################

def parse_sessions(resource):
    try:
        key, session = libra.ParseSessionsFromYQLResource(resource)
    except Exception as e:
        return

    for request in session.GetRequests():
        if not request.IsA('TYandexProductsSearchRequestProperties'):
            continue
        if not request.IsA('TBaobabProperties') or request.BaobabTree() is None:
            continue

        joiner = request.BaobabTree()
        if joiner is None:
            continue

        marks = tamus.check_rules_merged({
            'page': '$page',
            'product-card': '$main // productCard',
        }, joiner)

        if (len(marks.markers2blocks.get('page', [])) == 0):
            continue

        subservice = marks.markers2blocks.get('page', [{}])[0].attrs.get("subservice")
        if subservice != "search":
            continue

        record = dict(
            key=key,
            subkey=request.Timestamp,

            uid=key,
            ts=request.Timestamp,
            reqid=request.ReqId,
            query=request.Query,
            user_region=request.UserRegion,
        )

        record['subservice'] = subservice
        record['url'] = marks.markers2blocks.get('page', [{}])[0].attrs.get("url")

        rearr = request.RearrValues
        rearr_names = [
            "wizdetection_ecom_classifier_prob",
            "wizdetection_cehac_ecom_classifier_prob",
            "wizdetection_fashion_ecom_classifier_prob",
            "wizdetection_home_ecom_classifier_prob",
            "wizdetection_diy_ecom_classifier_prob",
            "wizdetection_pharma_ecom_classifier_prob",
            "GoodsCategoryFilterWorkedRuleMarker"
        ]
        for name in rearr_names:
            value = rearr.get(name, None)
            record[name] = value

        relev = request.RelevValues
        relev_names = [
            "query_about_one_product",
            "query_about_many_products",
        ]
        for name in relev_names:
            value = relev.get(name, None)
            record[name] = value

        record['shows'] = []
        for block in marks.markers2blocks.get('product-card', []):
            showUid = block.attrs.get("showUid")
            cardType = block.attrs.get("type")
            cardId = block.attrs.get("id")
            record['shows'].append({
                "showUid": showUid,
                "type": cardType,
                "cardId": cardId,
            })
        record['shows_len'] = len(record['shows'])

        yield Row(**record)
