-- https://a.yandex-team.ru/arcadia/products/analytics/charts/category_coverage

pragma yt.Pool = "goods_quality";
pragma yt.PoolTrees = "physical";
pragma yt.OperationSpec = "{reducer={cpu_limit=0.05}}";

--/*
$outputdir = '${global.outputdir}';
$outputdir_prime = '${global.outputdir_prime}';
$outputdir_parallel = '${global.outputdir_parallel}';
--*/

/*
$outputdir = '//home/goods_quality/charts/category_coverage';
$outputdir_prime = $outputdir || '/prime';
$outputdir_parallel = $outputdir || '/parallel';
--*/

/* ======================================================================== */

use hahn;

pragma yt.DefaultMaxJobFails = '1';
pragma yt.InferSchema = '10';
pragma yson.DisableStrict;
pragma SimpleColumns;

define action $merge_results($dir) as

$dir_cache = $dir || '/cache';
$table_merged = $dir || '/category_coverage_merged';
$table_sorted = $table_merged || '_sorted';

$all_results = select * from range($dir_cache, '0000-00-00', '9999-99-99', 'aggregation');

insert into $table_merged with truncate
select * from $all_results;

insert into $table_sorted with truncate
select * from $all_results
order by `timestamp` asc;

end define;

/* ======================================================================== */

do $merge_results($outputdir_prime);
do $merge_results($outputdir_parallel);

