#include <products/lib/canonize/urls.h>
#include <library/cpp/testing/unittest/registar.h>


Y_UNIT_TEST_SUITE(CanonizeTests) {
    Y_UNIT_TEST(MvideoTests) {
        UNIT_ASSERT_VALUES_EQUAL(
            "mvideo.ru/5b", 
            CanonizeUrl("https://www.mViDeo.ru/5b/")
        );
    }

    Y_UNIT_TEST(MvideoUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "mvideo.ru/products/nastolnaya-igra-hobby-world-vzryvnye-kotyata-18-915187-40074123", 
            CanonizeUrl("https://www.mvideo.ru/products/nastolnaya-igra-hobby-world-vzryvnye-kotyata-18-915187-40074123/specification")
        );
    }

    Y_UNIT_TEST(OzonTests) {
        UNIT_ASSERT_VALUES_EQUAL("ozon.ru", CanonizeUrl("http://ozon.ru"));
    }

    Y_UNIT_TEST(OzonUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "ozon.ru/context/detail/id/261626668", 
            CanonizeUrl("https://www.ozon.ru/context/detail/id/261626668/")
        );
        
    }

    Y_UNIT_TEST(OzonUncanonizedReviewsTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "ozon.ru/context/detail/id/239202101",
            CanonizeUrl("https://www.ozon.ru/product/umnye-chasy-barda-goose-smart-watch-hw22-smart-chasy-hw22-s-polnorazmernym-ekranom-i-aktivnoy-239202101/reviews/")
        );
    }

    Y_UNIT_TEST(WildberriesTest) {
        UNIT_ASSERT_VALUES_EQUAL("wildberries.ru", CanonizeUrl("https://m.wildberries.ru"));
    }

    Y_UNIT_TEST(WildberriesDoubledDetailTests) {
        UNIT_ASSERT_VALUES_EQUAL("wildberries.ru/detail.aspx", CanonizeUrl("http://wildberries.ru/detail.aspx/detail.aspx"));
    }

    Y_UNIT_TEST(WildberriesUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "wildberries.ru/catalog/10002275/detail.aspx", 
            CanonizeUrl("https://www.wildberries.ru/catalog/10002275/otzyvy")
        );
    }

    Y_UNIT_TEST(AliTest) {
        UNIT_ASSERT_VALUES_EQUAL("aliexpress.ru", CanonizeUrl("m.aliexpress.ru"));
    }

    Y_UNIT_TEST(AliUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "aliexpress.ru/item/32844735740.html", 
            CanonizeUrl("https://aliexpress.ru/catalog/4k-3840-2160.html?&item_id=32844735740&sku_id=65158917759")
        );
    }

    Y_UNIT_TEST(SvyaznoyTest) {
        UNIT_ASSERT_VALUES_EQUAL("svyaznoy.ru", CanonizeUrl("www.svyaznoy.ru"));
    }

    Y_UNIT_TEST(SvyaznoyUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "svyaznoy.ru/catalog/accessories/10121/5873666",
            CanonizeUrl("https://www.svyaznoy.ru/catalog/accessories/10121/5873666/availability/petropavlovsk-kamchatskiy")
        );
    }

    Y_UNIT_TEST(SbermegamarketTest) {
        UNIT_ASSERT_VALUES_EQUAL("sbermegamarket.ru", CanonizeUrl("sbermegamarket.ru"));
    }

    Y_UNIT_TEST(SbermegamarketUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "sbermegamarket.ru/catalog/details/posudomoechnaya-mashina-45-sm-whirlpool-wsfe-2b19-eu-100024215273", 
            CanonizeUrl("https://sbermegamarket.ru/catalog/details/posudomoechnaya-mashina-45-sm-whirlpool-wsfe-2b19-eu-100024215273/spec/")
        );
    }

    Y_UNIT_TEST(ZdravcityTest) {
        UNIT_ASSERT_VALUES_EQUAL("zdravcity.ru", CanonizeUrl("zdravcity.ru"));
    }

    Y_UNIT_TEST(ZdravcityUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "zdravcity.ru/p_multi-tabs-immuno-pljus-tab-zhev-n30-0012006.html", 
            CanonizeUrl("https://zdravcity.ru/p_multi-tabs-immuno-pljus-tab-zhev-n30-0012006.html?&https://clickserve.dartsearch.net/link/click?lid=39700062648227410&ds_s_kwgid=58700006954280618=&gclsrc=aw.ds")
        );
    }

    Y_UNIT_TEST(CitilinkTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "citilink.ru", 
            CanonizeUrl("https://www.citilink.ru/")
        );
    }

    Y_UNIT_TEST(CitilinkUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "citilink.ru/product/mfu-lazernyi-canon-i-sensys-mf237w-bundle-a4-wifi-v-komplekte-kartridz-1522675", 
            CanonizeUrl("https://www.citilink.ru/product/mfu-lazernyi-canon-i-sensys-mf237w-bundle-a4-wifi-v-komplekte-kartridz-1522675/properties/")
        );
    }

    Y_UNIT_TEST(CitilinkWithImportantCgiTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "citilink.ru/product/shveinaya-mashina-janome-lw-17-belyi-414214?mrkt=psk_cl",
            CanonizeUrl(
                "https://www.citilink.ru/product/shveinaya-mashina-janome-lw-17-belyi-414214/properties/?mrkt=psk_cl",
                "",
                "mrkt")
        );
    }

    Y_UNIT_TEST(EldoradoTest) {
        UNIT_ASSERT_VALUES_EQUAL("eldorado.ru", CanonizeUrl("eldorado.ru"));
    }

    Y_UNIT_TEST(EldoradoUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "eldorado.ru/cat/detail/hdmi-kabel-monster-essentials-ultrahd-4k-1-82-m-122947-00",
            CanonizeUrl("https://www.eldorado.ru/cat/detail/hdmi-kabel-monster-essentials-ultrahd-4k-1-82-m-122947-00/?show=response")
        );
    }

    Y_UNIT_TEST(CarlonTest) {
        UNIT_ASSERT_VALUES_EQUAL("carlon.ru", CanonizeUrl("carlon.ru"));
    }

    Y_UNIT_TEST(CarlonUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "carlon.ru/zapchasti/man/3127930075", 
            CanonizeUrl("https://carlon.ru/sankt-peterburg/zapchasti/MAN/3127930075")
        );
    }

    Y_UNIT_TEST(EvropharmTest) {
        UNIT_ASSERT_VALUES_EQUAL("evropharm.ru", CanonizeUrl("evropharm.ru"));
    }

    Y_UNIT_TEST(EvropharmUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "evropharm.ru/products/protargol-rastvor-2percent-10-ml.aspx", 
            CanonizeUrl("https://evropharm.ru/ruza/Products/protargol-rastvor-2percent-10-ml.aspx")
        );
    }

    Y_UNIT_TEST(MegaptekaTest) {
        UNIT_ASSERT_VALUES_EQUAL("megapteka.ru", CanonizeUrl("megapteka.ru"));
    }

    Y_UNIT_TEST(MegaptekaUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "megapteka.ru/catalog/zabolevaniya-mochepolovoj-sistemy-54/tribestan-tb-p-o-37638", 
            CanonizeUrl("https://megapteka.ru/ruza/catalog/zabolevaniya-mochepolovoj-sistemy-54/tribestan-tb-p-o-37638")
        );
    }

    Y_UNIT_TEST(SidexTest) {
        UNIT_ASSERT_VALUES_EQUAL("sidex.ru", CanonizeUrl("sidex.ru"));
    }

    Y_UNIT_TEST(SidexUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "sidex.ru/view.php?id=772780", 
            CanonizeUrl("https://sidex.ru/view.php?id=772780&breg=ucityw_1526273")
        );
    }

    Y_UNIT_TEST(VseinstrumentiUncanonizedTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "vseinstrumenti.ru/santehnika/vodonagrevateli/elektricheskie/nakopitelnye/vertikalnye/atlantic/opro_slim_50_pc_841133", 
            CanonizeUrl("https://m.vseinstrumenti.ru/santehnika/vodonagrevateli/elektricheskie/nakopitelnye/vertikalnye/atlantic/opro_slim_50_pc_841133/otzyvy/")
        );
    }

    Y_UNIT_TEST(OzonTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "ozon.ru/context/detail/id/311186859", 
            CanonizeUrl("https://www.ozon.ru/context/detail/id/311186859?reviewsVariantMode=2&sh=8QQtkhpM")
        );
        UNIT_ASSERT_VALUES_EQUAL(
            "ozon.ru/context/detail/id/239202101", 
            CanonizeUrl("https://www.ozon.ru/product/umnye-chasy-barda-goose-smart-watch-hw22-smart-chasy-hw22-s-polnorazmernym-ekranom-i-aktivnoy-239202101/reviews/")
        );
        UNIT_ASSERT_VALUES_EQUAL(
            "ozon.ru/context/detail/id/232534056", 
            CanonizeUrl("https://www.ozon.ru/product/lampa-dlya-rasteniy-seveka-polnyy-spektr-s-diodami-samsung-samsung-lm301b-i-drayverom-232534056?")
        );

        UNIT_ASSERT_VALUES_EQUAL(
            "ozon.ru/context/detail/id/247820947", 
            CanonizeUrl("https://www.ozon.ru/product/bts-bolshaya-kniga-sprinkel-keti-247820947/?pid=partner_pg&is_retargeting=true")
        );
    }

    Y_UNIT_TEST(DefaultCGIListAndPonycodeTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "xn--h1alffa9f.xn--p1ai/page", 
            CanonizeUrl("https://www.россия.рф/page?utm_content=buffercf3b2&utm_medium=social&utm_source=facebook.com&utm_campaign=buffer")
        );
    }

    Y_UNIT_TEST(AliCGITest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "aliexpress.ru/item/1005002704208415.html", 
            CanonizeUrl("https://www.aliexpress.ru/item/1005002704208415.html?feed_id=73")
        );
    }

    Y_UNIT_TEST(OzonLinkTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "ozon.ru/context/detail/id/136681824", 
            CanonizeUrl("ozon.onelink.me/snmz?af_android_url=https%3A//www.ozon.ru/product/nivea-care-uvlazhnyayushchiy-intensivnyy-krem-dlya-litsa-s-maslom-shi-dlya-vseh-tipov-kozhi-100-ml-136681824/&af_click_lookback=7d&af_dp=ozon%3A//product/136681824/&af_ios_url=https%3A//www.ozon.ru/product/nivea-care-uvlazhnyayushchiy-intensivnyy-krem-dlya-litsa-s-maslom-shi-dlya-vseh-tipov-kozhi-100-ml-136681824/&af_web_dp=https%3A//www.ozon.ru/product/nivea-care-uvlazhnyayushchiy-intensivnyy-krem-dlya-litsa-s-maslom-shi-dlya-vseh-tipov-kozhi-100-ml-136681824/&is_retargeting=true")
        );
    }

    Y_UNIT_TEST(DecodeAndNewCgiTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "onlinetrade.ru/catalogue/videokarty-c338/gigabyte/videokarta_gigabyte_geforce_gt_1030_1290mhz_pci_e_3.0_2048mb_6008mhz_64_bit_dvi_hdmi_oc_gv_n1030oc_2gi-1000838.html", 
            CanonizeUrl("onlinetrade.ru/catalogue/videokarty-c338/gigabyte/videokarta_gigabyte_geforce_gt_1030_1290mhz_pci_e_3.0_2048mb_6008mhz_64_bit_dvi_hdmi_oc_gv_n1030oc_2gi-1000838.html%3futm_source%3dgoogle%26utm_medium%3dcpc&sa=u&ved=0ahukewistpby9-_1ahvfiyskhxjmdmsq2ykiga&usg=aovvaw1i4mjihptxsxeoa8dqjtax")
        );

    }

    Y_UNIT_TEST(VseInstrumentiTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "vseinstrumenti.ru/avtogarazhnoe-oborudovanie/oborudovanie-i-instrument-dlya-avtoservisa-i-sto/semniki/instrument-dlya-podshipnikov/podshipnikov/tundra/75-mm-878160", 
            CanonizeUrl("https://www.vseinstrumenti.ru/avtogarazhnoe-oborudovanie/oborudovanie-i-instrument-dlya-avtoservisa-i-sto/semniki/instrument-dlya-podshipnikov/podshipnikov/tundra/75-mm-878160/&sa=U&ved=0ahUKEwiyp4XWivD1AhWDi8MKHQijBegQ2ykIFA&usg=AOvVaw1kKj2Ui1hyDfsYAx0Ys_iL")
        );        
    }

    Y_UNIT_TEST(CgiPatternTest) {
        UNIT_ASSERT_VALUES_EQUAL(
            "example.com?a=1",
            CanonizeUrl("https://example.com?a=1&cgi_with_long_name=0", "*cgi_with_long_name")
        );
    }
};
