from quality.webfresh.libraries.vh_graph import Graph

import vh


class SearchEmptySerpsGraph(Graph):
    PV_EMPTY_SERPS_METRIC = 'empty-serp'

    SINGLE_OPTION_TO_JSON_OP = vh.op(id='2fdd4bb4-4303-11e7-89a6-0025909427cc')
    TAKE_PV_OFFLINE_FROM_PROD_OP = vh.op(id='4ec76bb4-28d4-4f65-add7-6026768f432d')

    def __init__(self) -> None:
        super().__init__(dict())

    def get_metrics_config(self) -> vh.frontend.targets.File:
        return self.SINGLE_OPTION_TO_JSON_OP(
            _options={
                'input': '["%s"]' % self.PV_EMPTY_SERPS_METRIC,
            }
        ).output

    def get_test_cgi(self, threshold: float) -> str:
        return f'&rearr=market_relevance_formula_threshold={threshold}'

    def get_launch_template_file_target(self, metrics_config: vh.frontend.targets.File,
                                        testid: str, query: str, cgi: str, test_extra_cgi: str,
                                        name: str, max_failed_rate: str,
                                        max_running_jobs: int) -> vh.frontend.targets.File:
        return self.TAKE_PV_OFFLINE_FROM_PROD_OP(
            metrics_config=metrics_config,
            _options={
                'test_ids': [testid],
                'queries': [query],
                'cgi': cgi,
                'test-extra-cgi': test_extra_cgi,
                'name': name,
                'max_failed_rate': max_failed_rate,
                'max_running_jobs': max_running_jobs,
            }
        ).launchTemplate


class BinarySearch:

    def __init__(self, begin: float, end: float, eps: float, max_operations_count: int) -> None:
        self.begin = begin
        self.end = end
        self.eps = eps
        self.operations_count = 0
        self.max_operations_count = max_operations_count

    def get_threshold(self) -> float:
        return (self.begin + self.end) / 2

    def is_stop(self, value: float) -> bool:
        return not (self.operations_count < self.max_operations_count and abs(value) > self.eps)

    def next_step(self, threshold: float, value: float) -> None:
        self.operations_count += 1
        if value > 0:
            self.end = threshold
        else:
            self.begin = threshold
