#include <products/report_state_tool/protos/ReportState.pb.h>

#include <util/generic/vector.h>
#include <util/stream/str.h>
#include <util/stream/zlib.h>
#include <library/cpp/string_utils/base64/base64.h>

TString SaveReportState(const TCommonReportState& state) {
    TString serialized;
    {
        TStringOutput strOut(serialized);
        TZLibCompress zlibOut(&strOut);
        state.SerializeToArcadiaStream(&zlibOut);
    }
    return Base64EncodeUrl(serialized);
}


int main(int argc, char *argv[]) {

    TVector<TString> waremd5s;
    TVector<TString> modelIds;
    TVector<TString> skuIds;
    if (argc <= 2) {
        Cout << "Need more arguments\n";
        Cout << "Format: <count_of_skus> <count_of_offers> <sku> <model> <sku> <model> ... <ware_md5s> ...\n";
        return 0;
    }
    int sku_cnt = strtol(argv[1], NULL, 10);
    int offers_cnt = strtol(argv[2], NULL, 10);
    for (int i = 0; i < sku_cnt; i++) {
        skuIds.push_back(argv[3 + 2 * i]);
        modelIds.push_back(argv[3 + 2 * i + 1]);
    }
    for (int i = 0; i < offers_cnt; i++)
        waremd5s.push_back(argv[3 + sku_cnt * 2 + i]);

    TCommonReportState reportState;

    auto* rs = reportState.mutable_search_state();
    for (size_t i = 0; i < skuIds.size(); i++) {
        auto* doc = rs->add_nailed_docs();
        doc->set_model_id(modelIds[i]);
        doc->set_sku_id(skuIds[i]);
    }

    for (size_t i = 0; i < waremd5s.size(); i++) {
        auto* doc = rs->add_nailed_docs();
        doc->set_ware_id(waremd5s[i]);
    }

    Cout << SaveReportState(reportState) << "\n";
}   
