import argparse
import os

import bannerland.backup_yt_tables.lib as backup_yt_tables


def main():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('--yt-token', default=os.getenv('YT_TOKEN'))
    parser.add_argument('--solomon-token', default=os.getenv('SOLOMON_TOKEN'))
    parser.add_argument('--release-type', choices=['stable', 'testing'], default='testing')

    args = parser.parse_args()

    backup_yt_tables.run(
        yt_token=args.yt_token,
        solomon_token=args.solomon_token,
        release_type=args.release_type,
    )


if __name__ == '__main__':
    main()
