from sandbox import sdk2
from sandbox.projects.common import binary_task
import bannerland.backup_yt_tables.lib as backup_yt_tables


class IrtBackupYtTables(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024
        disk_space = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        yt_token = sdk2.parameters.YavSecret(
            "YAV secret identifier with YT OAuth token",
            default="sec-01ft5frsqx6dpn33x9v4njaq6y"
        )
        solomon_token = sdk2.parameters.YavSecret(
            "YAV secret identifier with YT OAuth token",
            default="sec-01fvmcbqen683frer1j81t2bgn"
        )

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        backup_yt_tables.run(
            yt_token=self.Parameters.yt_token.data()['yt_token'],
            solomon_token=self.Parameters.solomon_token.data()['solomon_token'],
            release_type=self.Parameters.ext_params.binary_executor_release_type,
        )
