import argparse
import json
import six
import sys
import urlpy

import yt.wrapper as yt

from bm.yt_tools import CacheMode

from bannerland.client.avatars import AvatarsClient
import irt.iron.options as iron_opts


def get_yt_client(cluster):
    return yt.YtClient(
        proxy=cluster,
        config={
            'token_path': iron_opts.get('yt_token_path'),
        },
    )


def process_images(avatars_client, input_stream, output_stream):
    urls = [line.rstrip() for line in input_stream]
    ava_urls = [six.ensure_str(urlpy.parse(six.ensure_text(url)).punycode().unicode) for url in urls]
    # avatars_client.get_avatars expected punycode url, avatars bin must return dict with source urls
    ava_url2url = {ava_url: url for ava_url, url in zip(ava_urls, urls)}

    ava_res = avatars_client.get_avatars(ava_urls)
    res = {}
    for ava_url, v in ava_res.items():
        url = ava_url2url[ava_url]
        if v.get('avatars'):
            v['avatars'] = json.loads(v['avatars'])  # to avoid stacked json
        res[url] = v
    output_stream.write(json.dumps(res) + "\n")


if __name__ == '__main__':
    argparser = argparse.ArgumentParser(
        formatter_class=argparse.ArgumentDefaultsHelpFormatter,
        description='read image urls from stdin, output json-encoded {url: response} dict to stdout',
    )
    argparser.add_argument('--no-read-cache', action='store_true', help='not read avatars cache (if set DEBUG env read from test dyntable cache)')
    argparser.add_argument('--no-write-cache', action='store_true', help='not write avatars cache (if set DEBUG env write to test dyntable cache)')
    argparser.add_argument('--task-type', help='for select dyntable cache', default='perf', choices=['perf', 'dyn'])

    args = argparser.parse_args()

    read_mode = CacheMode.NEVER if args.no_read_cache else CacheMode.TRY
    write_mode = CacheMode.NEVER if args.no_write_cache else CacheMode.TRY
    avatars_client = AvatarsClient.init_by_task_type(
        task_type=args.task_type,
        read_cache=read_mode,
        write_cache=write_mode,
        lookup_client=get_yt_client('markov'),
        map_reduce_client=get_yt_client('hahn'),
    )

    process_images(avatars_client, sys.stdin, sys.stdout)
