import datetime

import yt.wrapper as yt

import irt.bannerland.hosts
import irt.bannerland.options
import irt.iron.options
import irt.logging


logger = irt.logging.getLogger(None, __name__)


if __name__ == '__main__':
    cur_role = irt.bannerland.hosts.get_host_role()
    cur_host = irt.bannerland.hosts.get_curr_host()
    locks_dir = irt.bannerland.options.get_option('alive_yt_locke_path')
    yt_table = '{}/{}/{}'.format(locks_dir, cur_role, cur_host)

    yt.config['proxy']['url'] = 'locke'
    yt.config['token_path'] = irt.iron.options.get('yt_token_path')

    if not yt.exists(yt_table):
        logger.warning('yt node %s not exists; create', yt_table)
        yt.create('table', yt_table, recursive=True, ignore_existing=True)

    yt.set_attribute(yt_table, 'expiration_time', (datetime.datetime.now() + datetime.timedelta(hours=2)).isoformat())
    logger.info('set new expiration_time OK')
