#!/usr/bin/env python
# coding: utf-8

import os
import os.path
import filecmp
import sys
import datetime
import fcntl
import logging
import shutil
import os.path
import argparse
import subprocess

# TEMPORARY SCRIPT FOR RESOURCES BUILD


def main(output_dir):
    bin_dir = os.path.dirname(__file__)
    arc_dir = os.path.abspath(os.path.join(bin_dir, '../../../..'))

    ya = os.path.join(arc_dir, 'ya')

    pkg_list = ['bm_bannerland_lib', 'bm_dicts']
    pkg_path = 'rt-research/broadmatching/ya_packages'
    bin_list = ['make_pocket']
    bin_path = 'rt-research/bannerland/bin'
    targets = ['{}/{}'.format(pkg_path, pkg) for pkg in pkg_list] + ['{}/{}'.format(bin_path, binary) for binary in bin_list]

    build_root = output_dir + '/_arcadia_root'
    os.makedirs(build_root)
    build_cmd = [
        ya, 'make', '-rt', '--checkout',
        '--output', os.path.abspath(build_root),
    ] + targets
    logging.warning('build: %s', build_cmd)
    subprocess.check_call(build_cmd, cwd=arc_dir)

    for binary in bin_list:
        os.rename(
            os.path.join(build_root, bin_path, binary, binary),
            os.path.join(output_dir, binary),
        )
    for pkg in pkg_list:
        os.rename(
            os.path.join(build_root, pkg_path, pkg, pkg + '.tgz'),
            os.path.join(output_dir, pkg + '.tgz'),
        )
    shutil.rmtree(build_root)

    subprocess.check_call(['./make_pocket', '--dry-run'], cwd=output_dir)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('output_dir')
    args = parser.parse_args()
    main(args.output_dir)
