import argparse
import logging
import yt.wrapper as yt

import bannerland.prepare_input
import irt.common.logging
import irt.iron.options
import irt.bannerland.options


logger = logging.getLogger(__name__)


def run_joiner(task_type):
    joiner = bannerland.prepare_input.TasksOffersJoiner(yt_pool='bannerland-prod')
    joiner.merge_prod_by_task_type(task_type)


def join_task_and_offers(task_type):
    conf = irt.bannerland.options.get_cypress_config(task_type)

    # TODO: после переезда на SandBox оторвать
    lock_table = yt.ypath_join(conf.get_path('lock_dir'), 'merge_task_and_offers_lock')
    lock_client = yt.YtClient('hahn', config={'token_path': irt.iron.options.get('yt_token_path')})
    lock_client.create('table', lock_table, ignore_existing=True, recursive=True)
    with lock_client.Transaction():
        try:
            lock_client.lock(lock_table, mode='exclusive')
            run_joiner(task_type)
        except yt.YtHttpResponseError as err:
            logger.error('Fail take yt lock. script is already start. YT msg: %s', err.error)


def main():
    irt.common.logging.init_logging()
    argparser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    argparser.add_argument('--task-type', choices=['perf', 'dyn'], default='perf', help='subj')
    args = argparser.parse_args()
    join_task_and_offers(args.task_type)


if __name__ == '__main__':
    main()
