# encoding: utf-8
import argparse
import filelock
import logging

import bannerland.prepare_input


logging.basicConfig(format="%(asctime)s\t[%(process)d]\t%(message)s", level=logging.INFO)
logger = logging.getLogger(__name__)


def main():
    argparser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    argparser.add_argument('--task-type', choices=['perf', 'dyn'], default='perf', help='subj')

    args = argparser.parse_args()
    try:
        with filelock.FileLock('upload_tasks_and_offers_{}'.format(args.task_type)).acquire(timeout=0):
            uploader = bannerland.prepare_input.TasksOffersUploader()
            uploader.upload_prod_by_task_type(args.task_type)
    except filelock.Timeout:
        logger.warning('Another instance of this application currently holds the lock.')


if __name__ == '__main__':
    main()
