# coding: utf-8

import logging
import datetime

import yt.wrapper as yt

from bannerland.dir_worker.dir_worker import YtCollectDay
from irt.bannerland.options import get_cypress_config

from bannerland.yt_utils import get_yt_client


clear_configs = []
for task_type in ['perf', 'dyn']:
    cypress_config = get_cypress_config(task_type)
    clear_configs.append({
        'lock_table': yt.ypath_join(cypress_config.get_path('lock_dir'), 'collector'),
        'from_dir': cypress_config.get_path('tao_current'),
        'to_dir': cypress_config.get_path('tao_full_1d'),
        'day_limit': (7 if cypress_config.get_mode() == 'prod' else 3),
        'collect_type': 'day',
        'in_dt_format': 'merged_tasks_and_offers_%Y-%m-%d_%H:%M:%S',
        'expiration_timeout': datetime.timedelta(weeks=12)  # 3 months
    })


def main():
    lock_yt_client = get_yt_client()
    for clear_conf in clear_configs:
        lock_table = clear_conf.pop('lock_table')  # not used in YtCollectDay
        lock_yt_client.create("table", lock_table, ignore_existing=True, recursive=True)
        with lock_yt_client.Transaction():
            try:
                lock_yt_client.lock(lock_table, mode="exclusive")
            except yt.YtHttpResponseError as err:
                logging.warning("Fail take yt lock. script is already start. YT msg: %s", err.error)
                continue
            cl = YtCollectDay(get_yt_client())
            cl.run_from_config(clear_conf)


if __name__ == '__main__':
    main()
