import os

import irt.broadmatching.common_options
import irt.monitoring.libs.money_wow_statistics
import irt.monitoring.solomon.sensors


def read_token_from_file():
    tokens_folder = os.path.join(irt.broadmatching.common_options.get_options()["secrets"]["server_dir"], "tokens")
    token_file = os.path.join(tokens_folder, "artmon_oauth_token")
    with open(token_file, "r") as f:
        return f.read().strip()


def main():
    """
    Вызов функционала вычисления актуальной WOW-статистики в Артмоне и отправления её в Solomon
    """
    oauth_token = os.getenv("ARTMON_TOKEN", read_token_from_file())

    value_diff, monitor_all_sds, iso_timestamp = irt.monitoring.libs.money_wow_statistics.get_wow_statistics(oauth_token)
    ok_diff = irt.monitoring.libs.money_wow_statistics.evaluate_diff(value_diff)
    stat_solomon_sensors = irt.monitoring.libs.money_wow_statistics.get_stat_solomon_sensors(
        value_diff=value_diff,
        ok_diff=ok_diff,
        monitor_all_sds=monitor_all_sds,
        iso_timestamp=iso_timestamp,
    )
    irt.monitoring.solomon.sensors.SolomonAgentSensorsClient().push_sensors(stat_solomon_sensors)


if __name__ == "__main__":
    main()
