import argparse
import logging
import os

import bannerland.dyn_sources.generate_dse_banners.generate_filtered_links.lib as generate_filtered_links


def main():
    logging.basicConfig(format='%(asctime)s\t[%(process)d]\t%(message)s', level=logging.INFO)

    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('--yt-token', default=os.environ.get('YT_TOKEN'))
    parser.add_argument('--yt-pool')
    parser.add_argument('--release-type', choices=['stable', 'testing'], default='testing')

    args = parser.parse_args()

    generate_filtered_links.run(
        yt_client=generate_filtered_links.get_yt_client(args.yt_token, args.yt_pool, 'hahn'),
        release_type=args.release_type,
    )

if __name__ == '__main__':
    main()
