from sandbox import sdk2
from sandbox.projects.common import binary_task


class GenerateFilteredLinks(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024
        disk_space = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 5 * 60 * 60
        yt_token = sdk2.parameters.YavSecret(
            "YAV secret identifier with YT OAuth token",
            default="sec-01ft5frsqx6dpn33x9v4njaq6y"
        )
        yt_pool = sdk2.parameters.String("YT pool")

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        import bannerland.dyn_sources.generate_dse_banners.generate_filtered_links.lib as generate_filtered_links

        generate_filtered_links.run(
            yt_client=generate_filtered_links.get_yt_client(
                self.Parameters.yt_token.data()['yt_token'],
                self.Parameters.yt_pool,
                'hahn',
            ),
            release_type=self.Parameters.ext_params.binary_executor_release_type,
        )
