# coding: utf-8

import yt.wrapper as yt

from irt.bannerland.options import get_cypress_config

from .common import get_attr_name
from .set_direct_status import SetDirectStatusWorker
from .funnel import FunnelWorker
from .monitor import MonitorWorker, MonitorFSWorker, LogWorker
from .index import IndexWorker
from .rank import SelectTopFSWorker
from .full_state import AddToFullStateWorker, FinalizeFSWorker, SeparateFSWorker, PublishFSWorker, CheckFinalTableWorker
from .calculate_timings import CalculateTimingsWorker
from .export_deltas import DeltasFSWorker


# описание архивариусов
# поля worker-ов:
#   class:          subj
#   kwargs:         аргументы для конструктора архивариуса
perf_conf = get_cypress_config('perf')
PERF_WORKER_CONFIG = {
    'pocket': {
        'archive_dir': perf_conf.get_path('make_banners_archive'),
        'lock_dir': perf_conf.get_path('make_banners_dir') + '/archive_worker_locks',
        'workers': {
            # production workers:
            'set_direct_status': {
                'class': SetDirectStatusWorker,
            },
            'full_state': {
                'class': AddToFullStateWorker,
                'kwargs': {
                    'active_days_count': 14,
                    'yt_pool': 'bannerland-prod',
                },
            },

            # workers for analytics:
            'index': {
                'class': IndexWorker,
                'depend': ['full_state'],
            },
            'logs_stat': {
                'class': LogWorker,
                'depend': ['index'],
            },
            'funnel': {
                'class': FunnelWorker,
                'depend': ['full_state'],
                'kwargs': {
                    'info_dyntable': perf_conf.get_path('tasks_info_dyntable'),
                },
            },
            'monitor': {
                'class': MonitorWorker,
            },
        },
    },
    'full_state': {
        'archive_dir': perf_conf.get_path('full_state_archive'),
        'lock_dir': perf_conf.get_path('full_state_dir') + '/archive_worker_locks',
        'workers': {
            # production workers:
            'select_top_fs': {
                'class': SelectTopFSWorker,
                'kwargs': {
                    'yt_pool': 'bannerland-prod',
                    'input_name': 'bannerphrases',
                    'output_name': 'bannerphrases.top',
                    'bannerid_throttle_percent': 98,
                },
            },
            'finalize_fs': {
                'class': FinalizeFSWorker,
                'depend': ['select_top_fs'],
                'kwargs': {
                    'yt_pool': 'bannerland-prod',
                    'input_name': 'bannerphrases.top',
                },
            },
            'separate_fs': {
                'class': SeparateFSWorker,
                'depend': ['finalize_fs'],
                'kwargs': {
                    'yt_pool': 'bannerland-prod',
                },
            },
            'check_fs': {
                'class': CheckFinalTableWorker,
                'depend': ['separate_fs'],
                'kwargs': {
                    'yt_pool': 'bannerland-prod',
                },
            },
            'publish_fs': {
                'class': PublishFSWorker,
                'depend': ['check_fs'],
                'kwargs': {
                    'publish_mode': PublishFSWorker.Mode.publish_local,
                    'yt_pool': 'bannerland-prod',
                },
            },
            'transfer_fs': {
                'class': PublishFSWorker,
                'depend': ['publish_fs'],
                'kwargs': {
                    'publish_mode': PublishFSWorker.Mode.transfer_and_publish,
                    'yt_pool': 'bannerland-prod',
                },
            },
            'export_deltas': {
                'class': DeltasFSWorker,
                'depend': ['publish_fs'],
                'kwargs': {
                    'yt_pool': 'bannerland-prod',
                },
            },

            # other workers
            'monitor_fs': {
                'class': MonitorFSWorker,
                'depend': ['transfer_fs', 'export_deltas'],
            },
            'calculate_timings': {
                'class': CalculateTimingsWorker,
                'depend': ['transfer_fs'],
            }
        },
    },
}

dyn_conf = get_cypress_config('dyn')
DYN_WORKER_CONFIG = {
    'pocket': {
        'archive_dir': dyn_conf.get_path('make_banners_archive'),
        'lock_dir': yt.ypath_join(dyn_conf.get_path('make_banners_dir'), '/archive_worker_locks'),
        'workers': {
            # production workers:
            'set_direct_status': {
                'class': SetDirectStatusWorker,
            },
            'full_state': {
                'class': AddToFullStateWorker,
                'kwargs': {
                    'active_days_count': 14,
                    'yt_pool': 'bannerland-prod',
                },
            },
            # workers for analytics:
            'index': {
                'class': IndexWorker,
                'depend': ['full_state'],
            },
            'logs_stat': {
                'class': LogWorker,
                'depend': ['index'],
            },
            'funnel': {
                'class': FunnelWorker,
                'depend': ['full_state'],
                'kwargs': {
                    'info_dyntable': dyn_conf.get_path('tasks_info_dyntable'),
                },
            },
            'monitor': {
                'class': MonitorWorker,
            },
        },
    },
    'full_state': {
        'archive_dir': dyn_conf.get_path('full_state_archive'),
        'lock_dir': yt.ypath_join(dyn_conf.get_path('full_state_dir'), '/archive_worker_locks'),
        'workers': {
            # production workers:
            'select_top_fs': {
                'class': SelectTopFSWorker,
                'kwargs': {
                    'yt_pool': 'bannerland-prod',
                    'input_name': 'bannerphrases',
                    'output_name': 'bannerphrases.top',
                    'bannerid_throttle_percent': 100,
                },
            },
            'finalize_fs': {
                'class': FinalizeFSWorker,
                'depend': ['select_top_fs'],
                'kwargs': {
                    'yt_pool': 'bannerland-prod',
                    'input_name': 'bannerphrases.top',
                },
            },
            'separate_fs': {
                'class': SeparateFSWorker,
                'depend': ['finalize_fs'],
                'kwargs': {
                    'yt_pool': 'bannerland-prod',
                },
            },
            'check_fs': {
                'class': CheckFinalTableWorker,
                'depend': ['separate_fs'],
                'kwargs': {
                    'yt_pool': 'bannerland-prod',
                },
            },
            'publish_fs': {
                'class': PublishFSWorker,
                'depend': ['check_fs'],
                'kwargs': {
                    'publish_mode': PublishFSWorker.Mode.publish_local,
                    'yt_pool': 'bannerland-prod',
                },
            },
            'transfer_fs': {
                'class': PublishFSWorker,
                'depend': ['publish_fs'],
                'kwargs': {
                    'publish_mode': PublishFSWorker.Mode.transfer_and_publish,
                    'yt_pool': 'bannerland-prod',
                },
            },
            'export_deltas': {
                'class': DeltasFSWorker,
                'depend': ['publish_fs'],
                'kwargs': {
                    'yt_pool': 'bannerland-prod',
                },
            },

            # other workers
            'monitor_fs': {
                'class': MonitorFSWorker,
                'depend': ['transfer_fs', 'export_deltas'],
            },
        },
    },
}


def get_worker_conf(task_type, worker_type):
    d = {
        'perf': PERF_WORKER_CONFIG,
        'dyn': DYN_WORKER_CONFIG,
    }
    conf = d.get(task_type)
    if not conf:
        raise ValueError('archive worker conf for task_type={} not found'.format(task_type))

    return conf[worker_type]


def get_worker_attr_names(task_type, worker_type):
    conf = get_worker_conf(task_type, worker_type)
    return [get_attr_name(name) for name in conf['workers']]
