# coding: utf-8

import yt.wrapper as yt

from bannerland.archive_workers.common import BLYTWorker

SORT_CONFIG = {
    'generated_banners.final':       ['task_id', 'BannerID'],
    'log_merged':                    ['task_id', 'row_id', 'time'],
    'make_banners.add_avatars.done': ['task_id', 'BannerID'],
    'tasks.final':                   ['task_id'],
    'tasks_and_offers.final':        ['task_id', 'row_id'],
}

POOL_SIZE = 5


class IndexWorker(BLYTWorker):
    def do_work(self, pocket_dir):
        yt_client = self.yt_client
        with yt.OperationsTrackerPool(pool_size=POOL_SIZE, client=yt_client) as sort_tracker:
            for table in SORT_CONFIG:
                sort_tracker.add(yt.spec_builders.SortSpecBuilder()
                                   .input_table_paths(yt.ypath_join(pocket_dir, table))
                                   .sort_by(SORT_CONFIG[table]))
