# coding: utf8
import json
import six


# copypaste from http://stackoverflow.com/questions/956867/how-to-get-string-objects-instead-of-unicode-ones-from-json-in-python
def json_loads_byteified(json_doc):
    return _byteify(
        json.loads(json_doc, object_hook=_byteify),
        ignore_dicts=True,
    )


def _byteify(data, ignore_dicts=False):
    # if this is a unicode string, return its string representation
    if six.PY2 and isinstance(data, six.text_type):
        return six.ensure_str(data)

    # if this is a list of values, return list of byteified values
    if isinstance(data, list):
        return [_byteify(item, ignore_dicts=True) for item in data]

    # if this is a dictionary, return dictionary of byteified keys and values
    # but only if we haven't already byteified it
    if isinstance(data, dict) and not ignore_dicts:
        return {
            _byteify(key, ignore_dicts=True): _byteify(value, ignore_dicts=True) for key, value in data.iteritems()
        }
    # if it's anything else, return it in its original form
    return data


def deep_diff(old, new):
    old_type = type(old)

    if old_type != type(new):
        return 'type: {} => {}'.format(old_type, type(new).__name__)
    elif old_type == list or old_type == tuple:
        diff = {}
        old_len = len(old)
        new_len = len(new)
        for idx in range(max(old_len, new_len)):
            if idx >= old_len:
                diff_idx = 'came'
            elif idx >= new_len:
                diff_idx = 'gone'
            else:
                diff_idx = deep_diff(old[idx], new[idx])
            if diff_idx is not None:
                diff['index_' + str(idx)] = diff_idx
        return diff if diff else None
    elif old_type == dict:
        diff = {}
        old_keys = set(old.keys())
        new_keys = set(new.keys())
        for k in old_keys - new_keys:
            diff[k] = 'gone'
        for k in new_keys - old_keys:
            diff[k] = 'came'
        for k in old_keys & new_keys:
            diff_k = deep_diff(old[k], new[k])
            if diff_k is not None:
                diff[k] = diff_k
        return diff if diff else None
    else:
        if old != new:
            if isinstance(old, six.text_type) and isinstance(new, six.text_type):
                return 'value: {} => {}'.format(six.ensure_str(old), six.ensure_str(new))
            elif isinstance(old, str) and isinstance(new, str):
                return 'value: {} => {}'.format(old, new)
            else:
                return 'not_equal'
        else:
            return
