#!/usr/bin/env python
# -*- coding: utf8 -*-

import os
import os.path

import subprocess


def run_yt_local(args, read=False):
    pkg = package_dir()
    yt_local_env = {
        'NODE_PATH': pkg + '/node_modules',
        'PYTHONPATH': pkg + '/python',
        'PATH': ':'.join([
            pkg + '/bin',
            pkg + '/node/bin',
            os.environ['PATH'],
        ]),
        'YT_LOCAL_THOR_PATH': pkg + '/yt-thor',
    }
    env = os.environ.copy()
    env.update(yt_local_env)
    command = [pkg + '/bin/yt_local', '--path', storage_dir()] + args
    if read:
        return subprocess.check_output(command, env=env)
    else:
        subprocess.check_call(command, env=env)


def start():
    run_yt_local([
        'start',
        '--id', yt_local_id(),
        '--node-chunk-store-quota', '99000000000',
        '--jobs-memory-limit', '50000000000',
        '--jobs-cpu-limit', '12',
        '--fqdn', 'localhost',
    ])


def stop():
    run_yt_local(['stop', yt_local_id()])


def delete():
    run_yt_local(['delete', yt_local_id()])


def get_proxy():
    if not check_running():
        raise Exception("Local YT is not running; download and start it!")
    return run_yt_local(['get_proxy', yt_local_id()], read=True).rstrip()


def check_running():
    for line in run_yt_local(['list'], read=True).split("\n"):
        fields = line.split("\t")
        if len(fields) >= 2 and fields[0] == yt_local_id() and 'running' in fields[1]:
            return True
    return False


def yt_local_id():
    return 'bannerland'


def root_dir():
    home = os.path.expanduser('~')
    return home + '/yt_local'


def storage_dir():
    return root_dir() + '/storage'


def package_dir():
    return root_dir() + '/package'


def download(stable=False):
    pkg = package_dir()
    stable_url = 'https://proxy.sandbox.yandex-team.ru/785853248'
    last_url = 'https://proxy.sandbox.yandex-team.ru/last/YT_LOCAL'
    url = stable_url if stable else last_url
    if not os.path.exists(pkg):
        os.makedirs(pkg)
    tarball = 'yt_local_archive.tar'
    print("download: fetch yt_local tarball ...")
    subprocess.check_call([
        'wget',
        url,
        '-O', pkg + '/' + tarball,
    ])
    print("download: extract files ...")
    subprocess.check_call([
        'tar', 'xvf', tarball
    ], cwd=pkg)
    os.remove(pkg + '/' + tarball)

    print("download done!")
