import os

import yt.wrapper as yt

import irt.iron.options as iron_opts


def get_yt_token():
    env = os.environ
    if 'YT_TOKEN' in env:
        token = env['YT_TOKEN']
    else:
        token_path = env.get('YT_TOKEN_PATH', iron_opts.get('yt_token_path'))
        with open(token_path) as fh:
            token = fh.read().strip()
    return token


def get_yt_config():
    env = os.environ
    proxy = env.get('YT_PROXY', iron_opts.get('yt_default_proxy'))
    token = get_yt_token()

    conf = {
        'proxy': {'url': proxy},
        'token': token,
        'read_retries': {'enable': True},
        'spec_defaults': {'mapper': {'tmpfs_path': '.', 'copy_files': True}},
    }
    if 'YT_POOL' in env:
        conf['pool'] = env['YT_POOL']

    return conf


def get_yt_client(*args, **kwargs):
    yt_config = get_yt_config(*args, **kwargs)
    return yt.YtClient(config=yt_config)
