# -*- coding: utf-8 -*-

import sensors
from irt.monitoring.solomon.sensors import SolomonAgentSensorsClient


# Пока отправку сенсоров BL производим в рамках кода из 'rt-research/bannerland'.
# Немного позже будет реализована единая точки отправки (в 'rt-research/monitoring') всех наших сенсоров (IRT-1882).
def main():
    all_sensors = []

    for task_type in ['dyn', 'perf']:
        for sensor_prefix, func in [
            ('prepare_input', sensors.get_sensors_prepare_input),
            ('make_banners', sensors.get_sensors_make_banners),
            ('archive_workers', sensors.get_sensors_archive_workers),
        ]:
            sub_sensors = func(task_type)
            for sensor in sub_sensors:
                sensor["sensor"] = ".".join([task_type, sensor_prefix, sensor["sensor"]])
                sensor["service"] = "bannerland_yt"
                sensor["cluster"] = "yt_hahn"
            all_sensors.extend(sub_sensors)

    irt_solomon_client = SolomonAgentSensorsClient()
    irt_solomon_client.push_sensors(all_sensors)
