# coding=utf-8
import argparse
import logging
import os

import bannerland.monitoring.top_clients_monitor.lib as lib


log = logging.getLogger(__name__)
logging.basicConfig(format='%(asctime)s\t[%(process)d]\t%(message)s', level=logging.INFO)


def main():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('--banners-type', choices=['dyn', 'perf'], default='perf')
    parser.add_argument('--yt-cluster', choices=['hahn', 'arnold'], default='hahn')
    parser.add_argument('--yt-pool')
    parser.add_argument('--release-type', choices=['stable', 'testing'], default='testing')

    parser.add_argument('--yt-token', default=os.environ.get('YT_TOKEN'))
    parser.add_argument('--yql-token', default=os.environ.get('YQL_TOKEN'))
    parser.add_argument('--solomon-token', default=os.environ.get('SOLOMON_TOKEN'))

    args = parser.parse_args()

    monitor = lib.TopClientsMonitor(
        yt_token=args.yt_token,
        yql_token=args.yql_token,
        solomon_token=args.solomon_token,
        banners_type=args.banners_type,
        yt_cluster=args.yt_cluster,
        yt_pool=args.yt_pool,
        release_type=args.release_type,
    )
    monitor.run()

if __name__ == '__main__':
    main()
