# coding=utf-8


def combine_queries(queries):
    return ';\n'.join(queries)


def yql_aggregate_clients_stats(input_table, output_table, contexttype):
    yql_query = '''
        INSERT INTO `{output}` WITH TRUNCATE
        SELECT
            CAST(domainid as Int64) AS domainid,
            SUM(CAST(eventcost as Double) / 1000000) AS cost,
            COUNT(DISTINCT orderid) AS seen_orders_count
        FROM `{input}`
        WHERE
            contexttype == '{contexttype}' AND fraudbits == '0'
        GROUP BY
            domainid;
    '''
    return yql_query.format(input=input_table, output=output_table, contexttype=contexttype)


def yql_total_clients_expenses(input_table, output_table):
    yql_query = '''
        INSERT INTO `{output}` WITH TRUNCATE
        SELECT SUM(cost) as total
        FROM `{input}`;
    '''
    return yql_query.format(input=input_table, output=output_table)


def yql_top_clients(input_table, output_table, clients_expenses, fixed_top_clients_ids, min_cost_ratio, entry_time):
    domain_ids_list_str = ', '.join(map(str, fixed_top_clients_ids))
    yql_query = '''
        INSERT INTO `{output}` WITH TRUNCATE
        SELECT domainid, seen_orders_count, cost, {entry_time} as last_entry_time
        FROM `{input}`
        WHERE
            cost / {clients_expenses} >= {min_cost_ratio}
            OR
            domainid IN ({domain_ids_list});
    '''
    return yql_query.format(input=input_table, output=output_table, clients_expenses=clients_expenses,
                            min_cost_ratio=min_cost_ratio, domain_ids_list=domain_ids_list_str, entry_time=entry_time)


def yql_update_old_top(old_top, agr_log, output_table, clients_expenses, max_days, min_cost_ratio, cur_log_timestamp):
    yql_query = '''
        INSERT INTO `{output}` WITH TRUNCATE
        SELECT
            clients.domainid as domainid,
            clients.last_entry_time as last_entry_time,
            COALESCE(log.seen_orders_count, 0) as seen_orders_count,
            COALESCE(log.cost, 0) as cost
        FROM `{old_top}` as clients
        LEFT JOIN `{agr_log}` as log USING(domainid)
        WHERE
            ({cur_ts} - clients.last_entry_time) / 3600 / 24 < {max_days}
            OR
            CAST(log.cost as Double) / {clients_expenses} >= {min_cost_ratio};
    '''
    return yql_query.format(output=output_table, old_top=old_top, agr_log=agr_log, max_days=max_days,
                            clients_expenses=clients_expenses, min_cost_ratio=min_cost_ratio, cur_ts=cur_log_timestamp)


def yql_combine_tops(old_top, new_top, output_table):
    yql_query = '''
        INSERT INTO `{output}` WITH TRUNCATE
        SELECT
            domainid, SOME(cost) as cost,
            SOME(seen_orders_count) as seen_orders_count,
            MAX(last_entry_time) as last_entry_time
        FROM CONCAT(`{old_top}`, `{new_top}`)
        GROUP BY domainid;
    '''
    return yql_query.format(output=output_table, old_top=old_top, new_top=new_top)


def yql_append_domain(stats_table, target_domains, output_table):
    yql_query = '''
        INSERT INTO `{output}` WITH TRUNCATE
        SELECT
            domains.Domain as Domain,
            clients.* FROM `{stats_table}` as clients
        INNER JOIN `{target_domains}` as domains
            ON clients.domainid == domains.DomainID;
    '''
    return yql_query.format(output=output_table, stats_table=stats_table, target_domains=target_domains)


def yql_preprocess_full_state(fs_banners, output_table):
    yql_query = '''
        INSERT INTO
            `{output}` WITH TRUNCATE
        SELECT
            b.OrderID AS OrderID,
            b.Domain AS Domain,
            COUNT(*) AS children_count,
            SUM(ListLength(b.BroadPhrases)) AS phrases_count
        FROM
            `{fs_banners}` AS b
        GROUP BY
            b.OrderID, b.Domain;
    '''
    return yql_query.format(fs_banners=fs_banners, output=output_table)


def yql_active_orders(full_state, queue_table, output_table):
    yql_query = '''
        INSERT INTO `{output}` WITH TRUNCATE
        SELECT fs_orders.Domain as Domain, COUNT(DISTINCT fs_orders.OrderID) as active_orders_count,
            SUM(fs_orders.children_count) as children_count, SUM(fs_orders.phrases_count) as phrases_count
        FROM
            (SELECT DISTINCT OrderID FROM `{queue_table}`) as active_orders
        INNER JOIN `{preprocess_full_state}` as fs_orders
            ON CAST(active_orders.OrderID as Int64) == fs_orders.OrderID
        GROUP BY fs_orders.Domain;
    '''
    return yql_query.format(output=output_table, queue_table=queue_table, preprocess_full_state=full_state)


def yql_final_top(clients_stat, active_orders, output_table):
    yql_query = '''
        INSERT INTO `{output}` WITH TRUNCATE
        SELECT clients.*, COALESCE(orders.active_orders_count, 0) as active_orders_count,
            COALESCE(orders.children_count, 0) as children_count, COALESCE(orders.phrases_count, 0) as phrases_count
        FROM `{clients_stat}` as clients
        LEFT JOIN `{active_orders}` as orders USING (Domain);
    '''
    return yql_query.format(output=output_table, clients_stat=clients_stat, active_orders=active_orders)
