# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.common import binary_task


class TopClientsMonitor(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024
        disk_space = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        yt_token = sdk2.parameters.YavSecret(
            "YAV secret identifier with YT OAuth token",
            default="sec-01ft5frsqx6dpn33x9v4njaq6y"
        )
        yql_token = sdk2.parameters.YavSecret(
            "YAV secret identifier with YT OAuth token",
            default="sec-01fvfacd5bxa043420sym51r5n"
        )
        solomon_token = sdk2.parameters.YavSecret(
            "YAV secret identifier with YT OAuth token",
            default="sec-01fvmcbqen683frer1j81t2bgn"
        )
        with sdk2.parameters.RadioGroup("Banners type", required=True) as banners_type:
            banners_type.values.perf = banners_type.Value("perf", default=True)
            banners_type.values.dyn = banners_type.Value("dyn")

        with sdk2.parameters.RadioGroup("YT cluster", required=True) as yt_cluster:
            yt_cluster.values.hahn = yt_cluster.Value("hahn", default=True)
            yt_cluster.values.arnold = yt_cluster.Value("arnold")

        yt_pool = sdk2.parameters.String("YT pool")

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        import bannerland.monitoring.top_clients_monitor.lib as lib

        monitor = lib.TopClientsMonitor(
            yt_token=self.Parameters.yt_token.data()['yt_token'],
            yql_token=self.Parameters.yql_token.data()['yql_token'],
            solomon_token=self.Parameters.solomon_token.data()['solomon_token'],
            banners_type=self.Parameters.banners_type,
            yt_cluster=self.Parameters.yt_cluster,
            yt_pool=self.Parameters.yt_pool,
            release_type=self.Parameters.ext_params.binary_executor_release_type,
        )
        monitor.run()
