import argparse
import os

import bannerland.resource_generation.update_dyn_trashfilter.lib as update_dyn_trashfilter


def main():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('--yt-pool')
    parser.add_argument('--release-type', choices=['stable', 'testing'], default='testing')
    parser.add_argument('--yt-token', default=os.environ.get('YT_TOKEN'))

    args = parser.parse_args()

    update_dyn_trashfilter.run(
        None,
        yt_client=update_dyn_trashfilter.get_yt_client(args.yt_token, args.yt_pool, 'hahn'),
        release_type=args.release_type,
    )

if __name__ == '__main__':
    main()
